/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.controllers;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobUtils {
    private static final Logger LOGGER = LogManager.getLogger(JobUtils.class);
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private JobUtils() {
    }

    public static void waitForJobDeletion(String name) {
        LOGGER.debug("Waiting for ReplicaSet of Deployment {} deletion", (Object)name);
        TestUtils.waitFor((String)("ReplicaSet " + name + " to be deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_DELETION, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().listPods("job-name", name).isEmpty());
        LOGGER.debug("Job {} was deleted", (Object)name);
    }

    public static void deleteJobWithWait(String namespace, String name) {
        KubeClusterResource.kubeClient((String)namespace).deleteJob(name);
        JobUtils.waitForJobDeletion(name);
    }

    public static void waitForJobFailure(String jobName, String namespace, long timeout) {
        LOGGER.info("Waiting for job: {} will be in error state", (Object)jobName);
        TestUtils.waitFor((String)"job finished", (long)Constants.GLOBAL_POLL_INTERVAL, (long)timeout, () -> KubeClusterResource.kubeClient().getJobStatus(jobName) == false);
    }
}

