# Examples

This folder contains different examples of Strimzi custom resources and demonstrates how they can be used.

* [Kafka cluster](./kafka)
    * Kafka deployments with different types of storage
* [Kafka Connect and Kafka Connect Connector](./connect)
* [Kafka Mirror Maker 1 and 2](./mirror-maker)
* [Kafka Bridge](./bridge)
* [Cruise Control and Kafka Rebalance](./cruise-control)
* [Kafka users](./user)
* [Kafka topics](./topic)
* [Prometheus metric](./metrics)
    * Examples of Kafka components with enabled Prometheus metrics
    * Grafana dashboards
    * Prometheus Alert
    * Sample Prometheus installation files
    * Sample Grafana installation files
    * JMX Trans deployment
* [Security](./security)
    * Deployments of Kafka, Kafka Connect and HTTP Bridge using TLS encryption, authentication and authorization
* [Kafka Access examples](./kafka-access)
    * Examples of the `KafkaAccess` resources for the Strimzi Access Operator