/*
 * Copyright Kroxylicious Authors.
 *
 * Licensed under the Apache Software License version 2.0, available at http://www.apache.org/licenses/LICENSE-2.0
 */

package io.kroxylicious.kms.provider.fortanix.dsm.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Key response.
 *
 * @param kid key identifier.
 * @param customMetadata custom metadata
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public record KeyResponse(@JsonProperty(value = "kid") String kid,
                          @JsonProperty(value = "custom_metadata") Map<String, Object> customMetadata) {}
