/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.io;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.ops4j.io.Lister;
import org.ops4j.lang.NullArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipLister
implements Lister {
    private URL m_baseURL;
    private final Enumeration<? extends ZipEntry> m_zipEntries;
    private final Pattern[] m_includes;
    private final Pattern[] m_excludes;

    public ZipLister(URL baseURL, Enumeration<? extends ZipEntry> zipEntries, Pattern filter) {
        NullArgumentException.validateNotNull(baseURL, "Base url");
        NullArgumentException.validateNotNull(zipEntries, "Zip entries");
        NullArgumentException.validateNotNull(filter, "Filter");
        this.m_baseURL = baseURL;
        this.m_zipEntries = zipEntries;
        this.m_includes = new Pattern[]{filter};
        this.m_excludes = new Pattern[0];
    }

    public ZipLister(URL baseURL, Enumeration<? extends ZipEntry> zipEntries, Pattern[] includes, Pattern[] excludes) {
        NullArgumentException.validateNotNull(baseURL, "Base url");
        NullArgumentException.validateNotNull(zipEntries, "Zip entries");
        NullArgumentException.validateNotNull(includes, "Include filters");
        NullArgumentException.validateNotNull(includes, "Exclude filters");
        this.m_baseURL = baseURL;
        this.m_zipEntries = zipEntries;
        this.m_includes = includes;
        this.m_excludes = excludes;
    }

    @Override
    public List<URL> list() throws MalformedURLException {
        ArrayList<URL> content = new ArrayList<URL>();
        while (this.m_zipEntries.hasMoreElements()) {
            ZipEntry entry = this.m_zipEntries.nextElement();
            String fileName = entry.getName();
            if (entry.isDirectory() || !this.matchesIncludes(fileName) || this.matchesExcludes(fileName)) continue;
            content.add(new URL("jar:" + this.m_baseURL.toExternalForm() + "!/" + fileName));
        }
        return content;
    }

    private boolean matchesIncludes(String fileName) {
        if (this.m_includes.length == 0) {
            return true;
        }
        for (Pattern include : this.m_includes) {
            if (!include.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesExcludes(String fileName) {
        for (Pattern include : this.m_excludes) {
            if (!include.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }
}

