/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.netty.http.springboot;

import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.SecurityAuthenticator;
import org.apache.camel.component.netty.http.SecurityConstraint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * Netty HTTP server and client using the Netty 3.x library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.netty-http")
public class NettyHttpComponentConfiguration {

    /**
     * To use a custom org.apache.camel.component.netty.http.NettyHttpBinding
     * for binding to/from Netty and Camel Message API.
     */
    @NestedConfigurationProperty
    private NettyHttpBinding nettyHttpBinding;
    /**
     * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
     * headers.
     */
    @NestedConfigurationProperty
    private HeaderFilterStrategy headerFilterStrategy;
    /**
     * Refers to a
     * org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration for
     * configuring secure web resources.
     */
    private NettyHttpSecurityConfigurationNestedConfiguration securityConfiguration;
    /**
     * To use the NettyConfiguration as configuration when creating endpoints.
     */
    @NestedConfigurationProperty
    private NettyConfiguration configuration;
    /**
     * The core pool size for the ordered thread pool if its in use. The default
     * value is 16.
     */
    private Integer maximumPoolSize;

    public NettyHttpBinding getNettyHttpBinding() {
        return nettyHttpBinding;
    }

    public void setNettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
        this.nettyHttpBinding = nettyHttpBinding;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(
            HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public NettyHttpSecurityConfigurationNestedConfiguration getSecurityConfiguration() {
        return securityConfiguration;
    }

    public void setSecurityConfiguration(
            NettyHttpSecurityConfigurationNestedConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public NettyConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public Integer getMaximumPoolSize() {
        return maximumPoolSize;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public static class NettyHttpSecurityConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration.class;
        /**
         * Whether to enable authentication
         * <p/>
         * This is by default enabled.
         */
        private Boolean authenticate;
        /**
         * The supported restricted.
         * <p/>
         * Currently only Basic is supported.
         */
        private String constraint;
        /**
         * Sets the name of the realm to use.
         */
        private String realm;
        /**
         * Sets a {@link SecurityConstraint} to use for checking if a web
         * resource is restricted or not
         * <p/>
         * By default this is <tt>null</tt>, which means all resources is
         * restricted.
         */
        private SecurityConstraint securityConstraint;
        /**
         * Sets the {@link SecurityAuthenticator} to use for authenticating the
         * {@link HttpPrincipal} .
         */
        private SecurityAuthenticator securityAuthenticator;
        /**
         * Sets a logging level to use for logging denied login attempts (incl
         * stacktraces)
         * <p/>
         * This level is by default DEBUG.
         */
        private LoggingLevel loginDeniedLoggingLevel;
        private String roleClassName;

        public Boolean getAuthenticate() {
            return authenticate;
        }

        public void setAuthenticate(Boolean authenticate) {
            this.authenticate = authenticate;
        }

        public String getConstraint() {
            return constraint;
        }

        public void setConstraint(String constraint) {
            this.constraint = constraint;
        }

        public String getRealm() {
            return realm;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public SecurityConstraint getSecurityConstraint() {
            return securityConstraint;
        }

        public void setSecurityConstraint(SecurityConstraint securityConstraint) {
            this.securityConstraint = securityConstraint;
        }

        public SecurityAuthenticator getSecurityAuthenticator() {
            return securityAuthenticator;
        }

        public void setSecurityAuthenticator(
                SecurityAuthenticator securityAuthenticator) {
            this.securityAuthenticator = securityAuthenticator;
        }

        public LoggingLevel getLoginDeniedLoggingLevel() {
            return loginDeniedLoggingLevel;
        }

        public void setLoginDeniedLoggingLevel(
                LoggingLevel loginDeniedLoggingLevel) {
            this.loginDeniedLoggingLevel = loginDeniedLoggingLevel;
        }

        public String getRoleClassName() {
            return roleClassName;
        }

        public void setRoleClassName(String roleClassName) {
            this.roleClassName = roleClassName;
        }
    }
}