/**
 *  Copyright 2005-2016 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;

public class WatchPodsExample {

    public static void main(String... args) throws Exception {
        KubernetesClient client = new DefaultKubernetesClient();
        client.pods().watch(new io.fabric8.kubernetes.client.Watcher<Pod>() {
            @Override
            public void eventReceived(Action action, Pod pod) {
                System.out.println(action + ": " + pod);
            }


            @Override
            public void onClose(KubernetesClientException e) {
                System.out.println("Closed: " + e);
            }
        });
        client.close();
    }
}
