* [Overview](overview.md)
* [Getting Started](getStarted/index.md)
  * Kubernetes
    * [MiniKube](getStarted/minikube.md)
    * [Vagrant](getStarted/vagrant-kubernetes.md)
    * [Google Container Engine](getStarted/gke.md)
    * [Amazon Web Services](getStarted/aws.md)
    * [Kubernetes](getStarted/kubernetes.md)
  * OpenShift
    * [MiniShift](getStarted/minishift.md)
    * [Vagrant](getStarted/vagrant.md)
    * [oc cluster up](getStarted/ocClusterUp.md)
    * [Red Hat CDK](getStarted/cdk.md)
    * [OpenShift](getStarted/openshift.md)
      * [Install OpenShift](getStarted/installOpenShift.md)
    * [Accept self-signed certs](getStarted/browserCertificates.md)
    * [Setup Local OpenShift Client](getStarted/local.md)
  * [Persistence](getStarted/persistence.md)
  * [Troubleshooting](getStarted/troubleshooting.md)
  * [Installing apps](getStarted/apps.md)
  * [Develop locally](getStarted/develop.md)
* [Developing Microservices](develop/index.md)
  * [Create a microservice](develop/createMicroservice.md)
  * [Elasticity and Resilience](develop/elasticity.md)
  * [Design for Failure](develop/designForFailure.md)
  * [Service Discovery](develop/serviceDiscovery.md)
  * [Load balancing](develop/loadBalancing.md)
  * [Pipelines](develop/pipelines.md)
  * [Logging](develop/logging.md)
  * [Monitoring](develop/monitoring.md)
  * [Tracing](develop/tracing.md)
  * [Circuit Breakers](develop/circuitBreakers.md)
  * [Configuration](develop/configuration.md)
  * [Testing](testing.md)
* Developer Reference
  * [Spring Boot](springboot.md)
  * [Apache Karaf](karaf.md)
  * [CDI](cdi.md)
  * [Java Libraries](javaLibraries.md)
* [Microservices Platform](fabric8DevOps.md)
  * [Developer Console](console.md)
  * [CI and CD](cdelivery.md)
    * [Jenkins Pipeline Library](jenkinsWorkflowLibrary.md)
    * [fabric8.yml file](fabric8YmlFile.md)
  * [Management](management.md)
    * [Logging](logging.md)
    * [Metrics](metrics.md)
  * [ChatOps](chat.md)
  * [Chaos Monkey](chaosMonkey.md)
* [Integration](ipaas.md)
  * [Messaging](fabric8MQ.md)
  * [API Management](apiManagement.md)
    * [Apiman Components](apimanComponents.md)
    * [Getting Started](apimanGettingStarted.md)
    * [Data Model](apimanDataModel.md)
    * [Publish Service](apimanImportService.md)
    * [Consume a Service](apimanConsumeService.md)
* [Quickstarts](quickstarts/index.md)
  * [Archetypes](quickstarts/archetypes.md)
  * [Running](quickstarts/running.md)
  * [Walk-through](quickstarts/walkthrough.md)
* [Tools](tools.md)
    * [Forge](forge.md)
      * [Camel Maven Plugin](camelMavenPlugin.md)
    * [Maven Plugin](mavenPlugin.md)
      * [Old 2.x plugin](mavenPlugin2x.md)
          * [fabric8:migrate](mavenFabric8Migrate.md)
          * [docker:build](mavenDockerBuild.md)
          * [docker:push](mavenDockerPush.md)
          * [fabric8:apply](mavenFabric8Apply.md)
          * [fabric8:create-env](mavenFabric8CreateEnv.md)
          * [fabric8:create-routes](mavenFabric8CreateRoutes.md)
          * [fabric8:delete-pods](mavenFabric8DeletePods.md)
          * [fabric8:devops](mavenFabric8DevOps.md)
          * [fabric8:helm](mavenFabric8Helm.md)
          * [fabric8:helm-push](mavenFabric8HelmPush.md)
          * [fabric8:json](mavenFabric8Json.md)
            * [annotation processors](annotationProcessors.md)
          * [fabric8:recreate](mavenFabric8Recreate.md)
          * [fabric8:rolling](mavenFabric8Rolling.md)
    * [Helm](helm.md)
* [Annotations](annotations.md)
  * [Secret Annotations](secretAnnotations.md)
* [Architecture](architecture.md)
  * [Terminology](terminology.md)
  * [Pods](pods.md)
  * [Replication Controllers](replicationControllers.md)
  * [Labels](labels.md)
  * [Services](services.md)
  * [Service Linking](serviceLinking.md)
  * [Apps](apps.md)
  * [Environments](environments.md)
  * [Builds](builds.md)
* [Source Code](projects.md)
* [Changes from V1](v2-changes.md)
* [FAQ](FAQ.md)
  * [General Questions](faqGeneral.md)
  * [JBoss Fuse Questions](faqFuse.md)
  * [Kubernetes Questions](faqKubernetes.md)
  * [OpenShift Questions](https://help.openshift.com/hc/en-us/categories/200177370-Frequently-Asked-Questions)
