/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.lang;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import org.linkedin.util.exceptions.InternalException;
import org.linkedin.util.io.IOUtils;
import org.linkedin.util.text.IdentityString;

public class LangUtils {
    public static String identityString(Object o) {
        return IdentityString.FULL_IDENTITY_STRING.getIdentity(o);
    }

    public static String shortIdentityString(Object o) {
        return IdentityString.SHORT_IDENTITY_STRING.getIdentity(o);
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static boolean isEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static int compare(int o1, int o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 < o2) {
            return -1;
        }
        return 1;
    }

    public static int compare(long o1, long o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 < o2) {
            return -1;
        }
        return 1;
    }

    public static int compare(float o1, float o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 < o2) {
            return -1;
        }
        return 1;
    }

    public static int compareTo(Date d1, Date d2) {
        if (d1 == null) {
            if (d2 == null) {
                return 0;
            }
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        long delta = d1.getTime() - d2.getTime();
        if (delta > 0L) {
            return 1;
        }
        if (delta < 0L) {
            return -1;
        }
        return 0;
    }

    public static <T extends Serializable> T deepClone(T serializable) {
        if (serializable == null) {
            return null;
        }
        try {
            return IOUtils.deserialize(IOUtils.serialize(serializable));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalException(e);
        }
    }

    public static boolean convertToBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return LangUtils.convertToBoolean(o.toString());
    }

    public static boolean convertToBoolean(String s) {
        if (s == null) {
            return false;
        }
        return !s.equals("false") && !s.equals("no") && !s.equals("off");
    }

    public static String getStackTrace(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        return sw.toString();
    }
}

