/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.fusesource.ide.jvmmonitor.core.IHeapElement;
import org.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class OpenDeclarationAction
extends Action
implements ISelectionChangedListener {
    String className;
    private String methodName;
    private String[] parameters;
    private List<Integer> innterClassIndices;
    static boolean searchEngineInitialized = false;

    public OpenDeclarationAction() {
        this.setText(Messages.openDeclarationLabel);
        this.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.innterClassIndices = new ArrayList<Integer>();
    }

    public static OpenDeclarationAction createOpenDeclarationAction(IActionBars actionBars) {
        IAction action = actionBars.getGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.open.editor");
        if (action instanceof OpenDeclarationAction) {
            return (OpenDeclarationAction)action;
        }
        OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction();
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.open.editor", (IAction)openDeclarationAction);
        return openDeclarationAction;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            this.parseSelection((IStructuredSelection)event.getSelection());
        }
    }

    public void run() {
        if (this.className == null) {
            return;
        }
        IType source = null;
        try {
            source = this.searchSource();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (source == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.errorLabel, (String)Messages.openDeclarationFailedMsg);
            return;
        }
        IDebugModelPresentation presentation = DebugUITools.newDebugModelPresentation((String)JDIDebugModel.getPluginIdentifier());
        if (presentation == null) {
            return;
        }
        IEditorInput editorInput = presentation.getEditorInput((Object)source);
        if (editorInput == null) {
            return;
        }
        IEditorPart editorPart = null;
        try {
            editorPart = this.openEditor(editorInput, (ISourcePresentation)presentation, source);
        }
        catch (PartInitException e) {
            Activator.log(4, Messages.openEditorFailedMsg, e);
        }
        presentation.dispose();
        if (editorPart == null) {
            return;
        }
        try {
            this.highlightMethod(editorInput, editorPart);
        }
        catch (CoreException e) {
            Activator.log(4, Messages.highlightMethodFailedMsg, e);
        }
    }

    private void parseSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        boolean enabled = true;
        this.innterClassIndices.clear();
        if (element instanceof IMethodNode) {
            String qualifiedMethodName = ((IMethodNode)element).getName();
            int index = qualifiedMethodName.indexOf(40);
            String methodNameWithoutParameter = qualifiedMethodName.substring(0, index);
            String qualifiedParameters = qualifiedMethodName.substring(index, qualifiedMethodName.length());
            this.parameters = this.getSimplifiedParameters(qualifiedParameters);
            index = methodNameWithoutParameter.lastIndexOf(46);
            this.className = methodNameWithoutParameter.substring(0, index);
            this.methodName = methodNameWithoutParameter.substring(index + 1);
            if ("<init>".equals(this.methodName)) {
                this.methodName = this.getSimplifiedConstrucor(this.className);
            }
        } else if (element instanceof StackTraceElement) {
            this.className = ((StackTraceElement)element).getClassName();
            this.methodName = ((StackTraceElement)element).getMethodName();
            this.parameters = new String[0];
        } else if (element instanceof IHeapElement && !((IHeapElement)element).getClassName().endsWith("[]")) {
            this.className = ((IHeapElement)element).getClassName();
            this.methodName = null;
            this.parameters = new String[0];
        } else {
            this.className = null;
            this.methodName = null;
            enabled = false;
        }
        if (this.className != null && this.className.contains("$")) {
            String[] elements = this.className.split("\\$");
            this.className = elements[0];
            try {
                int i = 1;
                while (i < elements.length) {
                    this.innterClassIndices.add(Integer.valueOf(elements[i]));
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.setEnabled(enabled);
    }

    private void highlightMethod(IEditorInput editorInput, IEditorPart editorPart) throws CoreException {
        if (!(editorPart instanceof ITextEditor) || this.methodName == null || this.parameters == null) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocumentProvider provider = textEditor.getDocumentProvider();
        provider.connect((Object)editorInput);
        int offset = 0;
        int length = 0;
        ISourceRange range = this.getMethodNameRange(editorInput);
        if (range != null) {
            offset = range.getOffset();
            length = range.getLength();
        }
        textEditor.selectAndReveal(offset, length);
        provider.disconnect((Object)editorInput);
    }

    private IType searchSource() throws InterruptedException {
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setOpenOnRun(false);
        final IType[] source = new IType[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (!searchEngineInitialized) {
                    monitor.subTask(Messages.searchingSoruceMsg);
                    searchEngineInitialized = true;
                }
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                dialog.open();
                            }
                        });
                    }
                }, 400L);
                if (OpenDeclarationAction.this.className == null) {
                    return;
                }
                try {
                    source[0] = OpenDeclarationAction.this.doSearchSource(OpenDeclarationAction.this.className);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            dialog.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            Activator.log(4, NLS.bind((String)Messages.searchClassFailedMsg, (Object)this.className), e);
        }
        return source[0];
    }

    IType doSearchSource(String name) throws CoreException {
        final ArrayList results = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    results.add((IType)element);
                }
            }
        };
        String baseName = name.replace('$', '.');
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((String)baseName, (int)0, (int)0, (int)0);
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), requestor, null);
        if (results.size() > 0) {
            return (IType)results.get(0);
        }
        return null;
    }

    private IEditorPart openEditor(IEditorInput editorInput, ISourcePresentation presentation, Object source) throws PartInitException {
        if (editorInput == null) {
            return null;
        }
        String editorId = presentation.getEditorId(editorInput, source);
        if (editorId == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, editorId);
    }

    private ISourceRange getMethodNameRange(IEditorInput editorInput) throws JavaModelException {
        ITypeRoot typeRoot = JavaUI.getEditorInputTypeRoot((IEditorInput)editorInput);
        LinkedList<ISourceRange> sourceRanges = new LinkedList<ISourceRange>();
        if (typeRoot instanceof IClassFile) {
            IType type = ((IClassFile)typeRoot).getType();
            this.getMethodNameRange(type.getChildren(), 0, sourceRanges);
        } else if (typeRoot instanceof ICompilationUnit) {
            IType[] allTypes;
            ICompilationUnit unit = (ICompilationUnit)typeRoot;
            IType[] iTypeArray = allTypes = unit.getAllTypes();
            int n = allTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                this.getMethodNameRange(type.getChildren(), 0, sourceRanges);
                ++n2;
            }
        } else {
            return null;
        }
        if (sourceRanges.isEmpty()) {
            return null;
        }
        return sourceRanges.getFirst();
    }

    private void getMethodNameRange(IJavaElement[] javaElements, int level, LinkedList<ISourceRange> sourceRanges) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement instanceof IMethod) {
                if (this.innterClassIndices.size() > level) {
                    IJavaElement[] types = ((IMethod)javaElement).getChildren();
                    if (types != null && types.length == 1 && types[0] instanceof IType) {
                        this.getMethodNameRange(((IType)types[0]).getChildren(), level + 1, sourceRanges);
                    }
                } else if (this.methodName.equals(javaElement.getElementName())) {
                    String[] paramTypes = ((IMethod)javaElement).getParameterTypes();
                    String[] readableParamTypes = this.getReadableParamTypes(paramTypes);
                    boolean isMatch = true;
                    int i = 0;
                    while (i < readableParamTypes.length) {
                        if (this.parameters.length == i) break;
                        if (!readableParamTypes[i].equals(this.parameters[i])) {
                            isMatch = false;
                            sourceRanges.addLast(((IMethod)javaElement).getNameRange());
                            break;
                        }
                        ++i;
                    }
                    if (isMatch) {
                        sourceRanges.addFirst(((IMethod)javaElement).getNameRange());
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    private String[] getReadableParamTypes(String[] signatures) {
        String[] results = new String[signatures.length];
        int i = 0;
        while (i < results.length) {
            results[i] = Signature.toString((String)signatures[i]);
            ++i;
        }
        return results;
    }

    private String[] getSimplifiedParameters(String parameter) {
        String param = parameter.replaceAll("[()]", "");
        String[] results = param.split(",");
        int i = 0;
        while (i < results.length) {
            int index = results[i].lastIndexOf(36);
            if (index != -1) {
                results[i] = results[i].substring(index + 1).trim();
            } else {
                index = results[i].lastIndexOf(46);
                results[i] = results[i].substring(index + 1).trim();
            }
            ++i;
        }
        return results;
    }

    private String getSimplifiedConstrucor(String clazz) {
        int index = clazz.lastIndexOf(36);
        if (index != -1) {
            return clazz.substring(index + 1);
        }
        index = clazz.lastIndexOf(46);
        return clazz.substring(index + 1);
    }
}

