/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.editors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.fusesource.ide.jvmmonitor.core.IThreadElement;
import org.fusesource.ide.jvmmonitor.core.dump.ThreadDumpParser;
import org.fusesource.ide.jvmmonitor.internal.ui.editors.AbstractDumpEditor;
import org.fusesource.ide.jvmmonitor.internal.ui.editors.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.IThreadInput;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadSashForm;
import org.fusesource.ide.jvmmonitor.ui.Activator;
import org.xml.sax.SAXException;

public class ThreadDumpEditor
extends AbstractDumpEditor {
    ThreadSashForm threadSashForm;
    List<IThreadElement> threadListElements = new ArrayList<IThreadElement>();
    private Image threadImage;

    @Override
    protected void createClientPages() {
        this.createThreadsPage();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getContainer(), "org.fusesource.ide.jvmmonitor.ui.threads_dump_editor_content");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            String filePath = ((IFileEditorInput)input).getFile().getRawLocation().toOSString();
            this.parseDumpFile(filePath);
        } else if (input instanceof FileStoreEditorInput) {
            String filePath = ((FileStoreEditorInput)input).getURI().getPath();
            this.parseDumpFile(filePath);
        }
    }

    public void setFocus() {
        this.threadSashForm.setFocus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.threadImage != null) {
            this.threadImage.dispose();
        }
    }

    protected ThreadSashForm getThreadSashForm() {
        return this.threadSashForm;
    }

    private void createThreadsPage() {
        this.threadSashForm = new ThreadSashForm(this.getContainer(), this.getEditorSite().getActionBars());
        this.threadSashForm.setInput(new IThreadInput(){

            @Override
            public IThreadElement[] getThreadListElements() {
                return ThreadDumpEditor.this.threadListElements.toArray(new IThreadElement[0]);
            }
        });
        int page = this.addPage((Control)this.threadSashForm);
        this.setPageText(page, Messages.threadsTabLabel);
        this.setPageImage(page, this.getThreadImage());
        this.threadSashForm.refresh();
    }

    private Image getThreadImage() {
        if (this.threadImage == null || this.threadImage.isDisposed()) {
            this.threadImage = Activator.getImageDescriptor("icons/full/obj16/thread_obj.gif").createImage();
        }
        return this.threadImage;
    }

    private void parseDumpFile(final String filePath) {
        Job job = new Job(Messages.parseThreadDumpFileJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                ThreadDumpParser parser = new ThreadDumpParser(new File(filePath), ThreadDumpEditor.this.threadListElements, monitor);
                try {
                    parser.parse();
                }
                catch (ParserConfigurationException e) {
                    return new Status(4, "org.fusesource.ide.jvmmonitor.ui", "Could not load thread dump file.", (Throwable)e);
                }
                catch (SAXException e) {
                    return new Status(4, "org.fusesource.ide.jvmmonitor.ui", "Could not load thread dump file.", (Throwable)e);
                }
                catch (IOException e) {
                    return new Status(4, "org.fusesource.ide.jvmmonitor.ui", "Could not load thread dump file.", (Throwable)e);
                }
                ThreadDumpEditor.this.setProfileInfo(parser.getProfileInfo());
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ThreadDumpEditor.this.threadSashForm != null) {
                            (this).ThreadDumpEditor.this.threadSashForm.refresh();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

