/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.fusesource.ide.commons.ui.IConfigurableColumns;
import org.fusesource.ide.commons.ui.actions.ConfigureColumnsAction;
import org.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.OpenDeclarationAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.FindAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.FocusOnAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ShowCallersCalleesAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ConfigurableFilteredTree;

public abstract class AbstractFilteredTree
extends ConfigurableFilteredTree {
    protected IActionBars actionBars;
    OpenDeclarationAction openAction;
    FindAction findAction;
    CopyAction copyAction;
    FocusOnAction focusOnFrameAction;
    ShowCallersCalleesAction showCallersCalleesAction;
    protected ConfigureColumnsAction configureColumnsAction;

    protected AbstractFilteredTree(Composite parent, IActionBars actionBars) {
        super(parent, 66306, new PatternFilter(), true);
        this.actionBars = actionBars;
        this.createContextMenu();
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.addListeners();
    }

    protected void createControl(Composite composite, int treeStyle) {
        super.createControl(composite, treeStyle);
        GridData data = (GridData)this.filterComposite.getLayoutData();
        data.horizontalIndent = 2;
        data.verticalIndent = 2;
        this.filterComposite.setLayoutData((Object)data);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateStatusLine(IStructuredSelection selection) {
        IStatusLineManager manager = this.actionBars.getStatusLineManager();
        IContributionItem[] items = manager.getItems();
        StatusLineContributionItem selfTimeStatusLineItem = null;
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof StatusLineContributionItem) {
                selfTimeStatusLineItem = (StatusLineContributionItem)item;
            }
            ++n2;
        }
        if (selfTimeStatusLineItem == null) {
            selfTimeStatusLineItem = new StatusLineContributionItem("SelfTimeContributionItem");
            manager.add((IContributionItem)selfTimeStatusLineItem);
        }
        if (selection == null) {
            selfTimeStatusLineItem.setText("");
            return;
        }
        double percentage = 0.0;
        double time = 0.0;
        Object[] objectArray = selection.toArray();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Object object = objectArray[n4];
            if (object instanceof IMethodNode) {
                percentage += ((IMethodNode)object).getSelfTimeInPercentage();
                time += (double)((IMethodNode)object).getSelfTime();
            }
            ++n4;
        }
        String text = "";
        if (percentage != 0.0) {
            text = String.valueOf(String.format("Self Time: %.0fms  %.1f", time, percentage)) + '%';
        }
        selfTimeStatusLineItem.setText(text);
    }

    public abstract ViewerType getViewerType();

    @Override
    protected abstract void configureTree();

    protected void createContextMenu() {
        this.openAction = OpenDeclarationAction.createOpenDeclarationAction(this.actionBars);
        this.copyAction = (CopyAction)this.actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.findAction = (FindAction)this.actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.focusOnFrameAction = new FocusOnAction(this);
        this.showCallersCalleesAction = new ShowCallersCalleesAction(this.getViewer());
        this.configureColumnsAction = new ConfigureColumnsAction((IConfigurableColumns)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractFilteredTree.this.focusOnFrameAction.aboutToShow();
                manager.add((IAction)AbstractFilteredTree.this.openAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)AbstractFilteredTree.this.copyAction);
                manager.add((IAction)AbstractFilteredTree.this.findAction);
                manager.add((IAction)AbstractFilteredTree.this.focusOnFrameAction);
                manager.add((IAction)AbstractFilteredTree.this.showCallersCalleesAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)AbstractFilteredTree.this.configureColumnsAction);
                AbstractFilteredTree.this.addMenus(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
    }

    protected void addMenus(IMenuManager manager) {
    }

    private void addListeners() {
        TreeViewer viewer = this.getViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractFilteredTree.this.openAction.selectionChanged(event);
                AbstractFilteredTree.this.copyAction.selectionChanged(event);
            }
        });
        viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AbstractFilteredTree.this.findAction.setViewer(AbstractFilteredTree.this.getViewer(), AbstractFilteredTree.this.getViewerType());
            }
        });
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.showCallersCalleesAction);
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AbstractFilteredTree.this.openAction.run();
            }
        });
    }

    public static enum ViewerType {
        CallTree,
        HotSpots,
        Caller,
        Callee;

    }
}

