/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;
import org.fusesource.ide.jvmmonitor.ui.ISharedImages;

public abstract class AbstractLabelProvider
implements ITableLabelProvider,
ILabelProvider,
ITableFontProvider,
ISharedImages {
    private static final String[] monospacedFonts = new String[]{"Courier New", "Monospace"};
    protected static final double HUNDRED = 100.0;
    private static final String[] PERCENTAGE_IMG_PATHS = new String[]{"icons/full/obj16/0percent.gif", "icons/full/obj16/2percent.gif", "icons/full/obj16/4percent.gif", "icons/full/obj16/7percent.gif", "icons/full/obj16/10percent.gif", "icons/full/obj16/15percent.gif", "icons/full/obj16/20percent.gif", "icons/full/obj16/25percent.gif", "icons/full/obj16/30percent.gif", "icons/full/obj16/35percent.gif", "icons/full/obj16/40percent.gif", "icons/full/obj16/50percent.gif", "icons/full/obj16/60percent.gif", "icons/full/obj16/70percent.gif", "icons/full/obj16/80percent.gif", "icons/full/obj16/90percent.gif", "icons/full/obj16/100percent.gif"};
    private static final double[] percentageCategories = new double[]{1.0, 3.0, 5.5, 8.5, 12.5, 17.5, 22.5, 27.5, 32.5, 37.5, 45.0, 55.0, 65.0, 75.0, 85.0, 95.0};
    private Image threadImage;
    private Image methodImage;
    private Image[] perrcentageImages = new Image[PERCENTAGE_IMG_PATHS.length];
    private Font monospacedFont;

    public void dispose() {
        if (this.threadImage != null) {
            this.threadImage.dispose();
        }
        if (this.methodImage != null) {
            this.methodImage.dispose();
        }
        Image[] imageArray = this.perrcentageImages;
        int n = this.perrcentageImages.length;
        int n2 = 0;
        while (n2 < n) {
            Image percentageImage = imageArray[n2];
            if (percentageImage != null) {
                percentageImage.dispose();
            }
            ++n2;
        }
        if (this.monospacedFont != null) {
            this.monospacedFont.dispose();
            this.monospacedFont = null;
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected Image getThreadImage() {
        if (this.threadImage == null || this.threadImage.isDisposed()) {
            this.threadImage = Activator.getImageDescriptor("icons/full/obj16/thread_obj.gif").createImage();
        }
        return this.threadImage;
    }

    protected Image getMethodImage() {
        if (this.methodImage == null || this.methodImage.isDisposed()) {
            this.methodImage = Activator.getImageDescriptor("icons/full/obj16/method_obj.gif").createImage();
        }
        return this.methodImage;
    }

    protected Image getPercentageImage(double percentage) {
        int index = 0;
        while (index < percentageCategories.length) {
            if (percentage <= percentageCategories[index]) break;
            ++index;
        }
        if (this.perrcentageImages[index] == null || this.perrcentageImages[index].isDisposed()) {
            this.perrcentageImages[index] = Activator.getImageDescriptor(PERCENTAGE_IMG_PATHS[index]).createImage();
        }
        return this.perrcentageImages[index];
    }

    protected String getMillisecondsText(long milliseconds, int length) {
        return String.format(String.valueOf(Messages.percentageLabel) + length + "d" + Messages.millisecondsLabel, milliseconds).toString();
    }

    protected Font getmonospacedFont(Font baseFont) {
        if (this.monospacedFont == null) {
            FontData[] fontData = baseFont.getFontData();
            String[] stringArray = monospacedFonts;
            int n = monospacedFonts.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!fontData[0].getName().equals(name)) {
                    fontData[0].setName(name);
                    break;
                }
                ++n2;
            }
            this.monospacedFont = new Font((Device)Display.getDefault(), fontData);
            return this.monospacedFont;
        }
        return this.monospacedFont;
    }
}

