/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.fusesource.ide.jvmmonitor.core.Activator;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeNode;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeParser;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;

public class AttributeContentProvider
implements ITreeContentProvider {
    protected List<AttributeNode> attributeRootNodes = new ArrayList<AttributeNode>();

    public Object[] getElements(Object inputElement) {
        return this.attributeRootNodes.toArray(new AttributeNode[0]);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AttributeNode) {
            return ((AttributeNode)parentElement).getChildren().toArray(new AttributeNode[0]);
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AttributeNode) {
            return ((AttributeNode)element).hasChildren();
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.attributeRootNodes.clear();
    }

    protected void refresh(IActiveJvm jvm, ObjectName objectName) {
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = jvm.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.getMBeanInfoFailedMsg, (Throwable)e);
        }
        if (mBeanInfo == null) {
            return;
        }
        ArrayList<AttributeNode> nodes = new ArrayList<AttributeNode>();
        AttributeParser parser = new AttributeParser();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        int n = mBeanAttributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanAttributeInfo attributeInfo = mBeanAttributeInfoArray[n2];
            String name = attributeInfo.getName();
            Object value = this.getAttributeValue(jvm, objectName, name);
            AttributeNode attributeNode = null;
            for (AttributeNode node : this.attributeRootNodes) {
                if (!node.getName().equals(name)) continue;
                attributeNode = node;
                attributeNode.setValue(value);
                break;
            }
            if (attributeNode == null) {
                attributeNode = new AttributeNode(name, null, value);
            }
            parser.refreshAttribute(attributeNode);
            attributeNode.setWritable(attributeInfo.isWritable());
            nodes.add(attributeNode);
            ++n2;
        }
        this.attributeRootNodes = nodes;
    }

    private Object getAttributeValue(IActiveJvm jvm, ObjectName objectName, String attributeName) {
        try {
            return jvm.getMBeanServer().getAttribute(objectName, attributeName);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.getMBeanAttributeFailedMsg, (Throwable)e);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            return null;
        }
        return null;
    }
}

