/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.InvokeDialog;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;

public class InvokeAction
extends Action
implements ISelectionChangedListener {
    private ObjectName objectName;
    private TableViewer tableViewer;
    private MBeanOperationInfo info;
    private AbstractJvmPropertySection section;

    public InvokeAction(TableViewer tableViewer, AbstractJvmPropertySection section) {
        this.tableViewer = tableViewer;
        this.section = section;
        this.setText(Messages.invokeLabel);
    }

    public void run() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm != null && this.objectName != null && this.info != null) {
            new InvokeDialog(this.tableViewer.getTable().getShell(), jvm, this.objectName, this.info).open();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object element;
        this.info = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof MBeanOperationInfo) {
            this.info = (MBeanOperationInfo)element;
        }
        this.setEnabled(this.info != null);
    }

    protected void selectionChanged(ObjectName name) {
        this.objectName = name;
    }
}

