/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.RefreshAction;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.ToggleOrientationAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanSashForm;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;

public class MBeansSection
extends AbstractJvmPropertySection {
    private static final String LAYOUT_MENU_ID = "layout";
    private MBeanSashForm sashForm;
    private RefreshAction refreshAction = new RefreshAction(this);
    private Separator separator = new Separator();
    private MenuManager layoutMenu = new MenuManager(Messages.layoutLabel, "layout");

    public void refresh() {
        if (!this.isSectionActivated) {
            return;
        }
        IActiveJvm jvm = this.getJvm();
        boolean isConnected = jvm != null && jvm.isConnected();
        this.refreshAction.setEnabled(isConnected);
        if (this.sashForm != null && !this.sashForm.isDisposed()) {
            this.refreshBackground(this.sashForm.getChildren(), isConnected);
            this.sashForm.refresh();
        }
    }

    @Override
    protected void createControls(Composite parent) {
        this.sashForm = new MBeanSashForm(parent, this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.fusesource.ide.jvmmonitor.ui.mbeans_page_content");
    }

    @Override
    protected void setInput(IWorkbenchPart part, ISelection selection, IActiveJvm newJvm, IActiveJvm oldJvm) {
    }

    @Override
    protected void addToolBarActions(IToolBarManager manager) {
        manager.insertAfter("defaults", (IContributionItem)this.separator);
        if (manager.find(this.refreshAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.refreshAction);
        }
    }

    @Override
    protected void removeToolBarActions(IToolBarManager manager) {
        manager.remove((IContributionItem)this.separator);
        manager.remove(this.refreshAction.getId());
    }

    @Override
    protected void addLocalMenus(IMenuManager manager) {
        if (manager.find(this.layoutMenu.getId()) == null) {
            manager.add((IContributionItem)this.layoutMenu);
            for (ToggleOrientationAction action : this.sashForm.getOrientationActions()) {
                if (this.layoutMenu.find(action.getId()) != null) continue;
                this.layoutMenu.add((IAction)action);
            }
        }
    }

    @Override
    protected void removeLocalMenus(IMenuManager manager) {
        manager.remove((IContributionItem)this.layoutMenu);
    }

    @Override
    protected void deactivateSection() {
        super.deactivateSection();
        if (this.sashForm != null && !this.sashForm.isDisposed()) {
            this.sashForm.deactivated();
        }
        IToolBarManager manager = this.getActionBars().getToolBarManager();
        this.removeToolBarActions(manager);
    }
}

