/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import javax.management.Notification;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Tree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationColumn;

public class NotificationComparator
extends ViewerComparator {
    private int sortDirection;
    private int columnIndex;

    public NotificationComparator(int columnIndex) {
        this.columnIndex = columnIndex;
        this.sortDirection = 1024;
    }

    public int compare(Viewer treeViewer, Object e1, Object e2) {
        int result = 0;
        if (!(e1 instanceof Notification && e2 instanceof Notification && treeViewer instanceof TreeViewer)) {
            return result;
        }
        Notification element1 = (Notification)e1;
        Notification element2 = (Notification)e2;
        Tree tree = ((TreeViewer)treeViewer).getTree();
        if (this.columnIndex == this.getColumnIndex(tree, NotificationColumn.MESSAGE)) {
            result = super.compare(treeViewer, (Object)element1.getMessage(), (Object)element2.getMessage());
        } else if (this.columnIndex == this.getColumnIndex(tree, NotificationColumn.DATE)) {
            result = element1.getTimeStamp() > element2.getTimeStamp() ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, NotificationColumn.TYPE)) {
            result = super.compare(treeViewer, (Object)element1.getType(), (Object)element2.getType());
        } else if (this.columnIndex == this.getColumnIndex(tree, NotificationColumn.SEQUENCE_NUMBER)) {
            int n = result = element1.getSequenceNumber() > element2.getSequenceNumber() ? 1 : -1;
        }
        if (this.sortDirection == 1024) {
            result *= -1;
        }
        return result;
    }

    protected void reverseSortDirection() {
        this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
    }

    protected int getSortDirection() {
        return this.sortDirection;
    }

    protected int getColumnIndex() {
        return this.columnIndex;
    }

    private int getColumnIndex(Tree tree, NotificationColumn column) {
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

