/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.Notification;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationColumn;
import org.fusesource.ide.jvmmonitor.ui.Activator;
import org.fusesource.ide.jvmmonitor.ui.ISharedImages;

public class NotificationsLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ISharedImages {
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private Image notificationImage;
    private TreeViewer treeViewer;

    public NotificationsLabelProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Notification) {
            return this.getColumnText((Notification)element, columnIndex);
        }
        return super.getText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(NotificationColumn.MESSAGE)) {
            return this.getNotificationImage();
        }
        return super.getImage(element);
    }

    public void dispose() {
        if (this.notificationImage != null) {
            this.notificationImage.dispose();
        }
    }

    private String getColumnText(Notification element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(NotificationColumn.TYPE)) {
            return element.getType();
        }
        if (columnIndex == this.getColumnIndex(NotificationColumn.DATE)) {
            return new SimpleDateFormat(DATE_FORMAT).format(new Date(element.getTimeStamp()));
        }
        if (columnIndex == this.getColumnIndex(NotificationColumn.SEQUENCE_NUMBER)) {
            return String.valueOf(element.getSequenceNumber());
        }
        if (columnIndex == this.getColumnIndex(NotificationColumn.MESSAGE)) {
            return element.getMessage();
        }
        return "";
    }

    private int getColumnIndex(NotificationColumn column) {
        Tree tree = this.treeViewer.getTree();
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Image getNotificationImage() {
        if (this.notificationImage == null || this.notificationImage.isDisposed()) {
            this.notificationImage = Activator.getImageDescriptor("icons/full/obj16/notification.png").createImage();
        }
        return this.notificationImage;
    }
}

