/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.memory.SWTResourcesPage;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class ClearSWTResourceAction
extends Action {
    SWTResourcesPage resourcePage;
    AbstractJvmPropertySection section;

    public ClearSWTResourceAction(SWTResourcesPage resourcePage, AbstractJvmPropertySection section) {
        this.setText(Messages.clearResourcesLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/clear_co.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/full/dlcl16/clear.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.resourcePage = resourcePage;
        this.section = section;
    }

    public void run() {
        new Job(Messages.clearResourcesJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = ClearSWTResourceAction.this.section.getJvm();
                if (jvm == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    jvm.getSWTResourceMonitor().clear();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.clearSWTResoucesFailedMsg, (CoreException)((Object)e));
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ClearSWTResourceAction.this.resourcePage.refresh(true);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

