/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import java.io.File;
import java.util.Date;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.ISnapshot;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.views.OpenSnapshotAction;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class DumpHprofAction
extends Action {
    AbstractJvmPropertySection section;

    public DumpHprofAction(AbstractJvmPropertySection section) {
        this.setText(Messages.dumpHprofLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/take_hprof_dump.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/full/dlcl16/take_hprof_dump.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.section = section;
    }

    public void run() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm == null) {
            return;
        }
        final String[] fileName = new String[1];
        final boolean[] transfer = new boolean[1];
        try {
            if (jvm.isRemote()) {
                final FileNameInputDialog dialog = new FileNameInputDialog(this.section.getPart().getSite().getShell(), this.getInitialFileName(jvm), this.isAgentLoaded(jvm));
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (dialog.open() == 0) {
                            fileName[0] = dialog.getFileName();
                            transfer[0] = dialog.isFileTransfered();
                        }
                    }
                });
                if (fileName[0] == null) {
                    return;
                }
            }
        }
        catch (JvmCoreException e) {
            Activator.log(Messages.dumpHeapDataFailedMsg, (CoreException)((Object)e));
            return;
        }
        this.dumpHprof(fileName[0], transfer[0]);
    }

    private void dumpHprof(final String fileName, final boolean transfer) {
        new Job(Messages.dumpHprofDataJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm activeJvm = DumpHprofAction.this.section.getJvm();
                if (activeJvm == null) {
                    return Status.CANCEL_STATUS;
                }
                IFileStore fileStore = null;
                try {
                    fileStore = activeJvm.getMBeanServer().dumpHprof(fileName, transfer, monitor);
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.dumpHeapDataFailedMsg, (CoreException)((Object)e));
                    return Status.CANCEL_STATUS;
                }
                if (DumpHprofAction.this.isMemoryAnalyzerInstalled() && fileStore != null) {
                    DumpHprofAction.this.section.setPinned(true);
                    OpenSnapshotAction.openEditor(fileStore);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    boolean isMemoryAnalyzerInstalled() {
        return Platform.getBundle((String)"org.eclipse.mat.ui") != null;
    }

    String getInitialFileName(IActiveJvm jvm) throws JvmCoreException {
        ObjectName objectName;
        try {
            objectName = new ObjectName("java.lang:type=Runtime");
        }
        catch (MalformedObjectNameException e) {
            throw new JvmCoreException(4, e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new JvmCoreException(4, e.getMessage(), (Throwable)e);
        }
        TabularData initialName = (TabularData)jvm.getMBeanServer().getAttribute(objectName, "SystemProperties");
        CompositeData compisiteData = initialName.get(new Object[]{"user.home"});
        String home = compisiteData.values().toArray(new String[0])[1];
        StringBuffer initialFileName = new StringBuffer(home);
        initialFileName.append(File.separator).append(new Date().getTime()).append('.').append(ISnapshot.SnapshotType.Hprof.getExtension());
        return initialFileName.toString();
    }

    boolean isAgentLoaded(IActiveJvm jvm) {
        ICpuProfiler.ProfilerState state = jvm.getCpuProfiler().getState(ICpuProfiler.ProfilerType.BCI);
        return state == ICpuProfiler.ProfilerState.READY || state == ICpuProfiler.ProfilerState.RUNNING;
    }

    private static class FileNameInputDialog
    extends Dialog {
        private static final String TRANSFER_KEY = "transfer";
        private static final char[] INVALID_CHARACTERS = new char[]{'*', '?', '\"', '<', '>', '|'};
        boolean isFileTransfered;
        Text fileNameField;
        private Label messageLabel;
        String fileName;
        private boolean isAgentLoaded;
        private Label imageLabel;

        public FileNameInputDialog(Shell shell, String initialFileName, boolean isAgentLoaded) {
            super(shell);
            this.fileName = initialFileName;
            this.isAgentLoaded = isAgentLoaded;
            this.isFileTransfered = Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName()).getBoolean(TRANSFER_KEY);
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.dumpHprofTitle);
            this.validate();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.addFileNameField(composite);
            this.addTransferFileButton(composite);
            this.addMessageLabel(composite);
            FileNameInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName()).put(TRANSFER_KEY, this.isFileTransfered);
            super.okPressed();
        }

        protected String getFileName() {
            return this.fileName;
        }

        private void addFileNameField(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(1808));
            Label label = new Label(composite, 0);
            label.setText(Messages.hprofFileLabel);
            this.fileNameField = new Text(composite, 2048);
            GridData gridData = new GridData(4, 0, true, false);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            this.fileNameField.setLayoutData((Object)gridData);
            this.fileNameField.setText(this.fileName);
            this.fileNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (FileNameInputDialog.this.validate()) {
                        FileNameInputDialog.this.fileName = FileNameInputDialog.this.fileNameField.getText();
                    }
                }
            });
        }

        private void addTransferFileButton(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(1808));
            final Button button = new Button(composite, 32);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileNameInputDialog.this.isFileTransfered = button.getSelection();
                }
            });
            button.setText(Messages.transferHprofFileLabel);
            button.setSelection(this.isFileTransfered);
            button.setEnabled(this.isAgentLoaded);
        }

        private void addMessageLabel(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(1808));
            this.imageLabel = new Label(composite, 0);
            this.imageLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
            this.messageLabel = new Label(composite, 0);
            this.messageLabel.setLayoutData((Object)new GridData(1808));
        }

        protected boolean isFileTransfered() {
            return this.isFileTransfered;
        }

        boolean validate() {
            String newText;
            String message = "";
            Image image = null;
            if (!this.isAgentLoaded) {
                message = Messages.transferingHprofFileNotSupportedMsg;
                image = JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            if ((newText = this.fileNameField.getText()).isEmpty()) {
                message = Messages.fileNameEmptyMsg;
                image = JFaceResources.getImage((String)"dialog_message_error_image");
            }
            char[] cArray = INVALID_CHARACTERS;
            int n = INVALID_CHARACTERS.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (this.fileNameField.getText().indexOf(c) != -1) {
                    message = Messages.pathContainsInvalidCharactersMsg;
                    image = JFaceResources.getImage((String)"dialog_message_error_image");
                    break;
                }
                ++n2;
            }
            this.imageLabel.setImage(image);
            this.messageLabel.setText(message);
            this.getButton(0).setEnabled(message.isEmpty());
            return true;
        }
    }
}

