/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class GarbageCollectorAction
extends Action {
    AbstractJvmPropertySection section;

    public GarbageCollectorAction(AbstractJvmPropertySection section) {
        this.setText(Messages.garbageCollectorLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/trash.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/full/dlcl16/trash.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.section = section;
    }

    public void run() {
        new Job(Messages.runGarbageCollectorJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = GarbageCollectorAction.this.section.getJvm();
                if (jvm == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    jvm.getMBeanServer().runGarbageCollector();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.runGarbageCollectorFailedMsg, (CoreException)((Object)e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

