/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.overview;

import java.text.NumberFormat;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.Messages;

public interface IFormat {
    public static final IFormat MILLISEC_FORMAT = new IFormat(){
        static final long SEC = 1000L;
        static final long MIN = 60000L;
        static final long HRS = 3600000L;
        static final long DAY = 86400000L;

        @Override
        public String format(Object object) {
            if (!(object instanceof Long)) {
                throw new IllegalArgumentException("unexpected type");
            }
            long millisec = (Long)object;
            long days = millisec / 86400000L;
            long hrs = (millisec %= 86400000L) / 3600000L;
            long min = (millisec %= 3600000L) / 60000L;
            double sec = (double)(millisec %= 60000L) / 1000.0;
            if (days > 0L) {
                return String.format("%d " + Messages.daysLabel + " %d " + Messages.hoursLabel + " %d " + Messages.minLabel + " %.0f " + Messages.secLabel, days, hrs, min, sec);
            }
            if (hrs > 0L) {
                return String.format("%d " + Messages.hoursLabel + " %d " + Messages.minLabel + " %.0f " + Messages.secLabel, hrs, min, sec);
            }
            if (min > 0L) {
                return String.format("%d " + Messages.minLabel + " %.0f " + Messages.secLabel, min, sec);
            }
            return String.format("%.3f " + Messages.secLabel, sec);
        }
    };
    public static final IFormat NANOSEC_FORMAT = new IFormat(){
        static final long SEC = 1000000000L;

        @Override
        public String format(Object object) {
            if (!(object instanceof Long)) {
                throw new IllegalArgumentException("unexpected type");
            }
            long nanosec = (Long)object;
            double sec = (double)nanosec / 1.0E9;
            return String.format("%.3f " + Messages.secLabel, sec);
        }
    };
    public static final IFormat BYTES_FORMAT = new IFormat(){

        @Override
        public String format(Object object) {
            if (!(object instanceof Long)) {
                throw new IllegalArgumentException("unexpected type");
            }
            long bytes = (Long)object;
            return String.valueOf(NumberFormat.getInstance().format(bytes / 1024L)) + " " + Messages.kBytesLabel;
        }
    };

    public String format(Object var1);
}

