/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.overview;

import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.RefreshAction;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.ShowInTimelineAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.PropertiesFilteredTree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewContentProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewLabelProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewProperties;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewProperty;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class OverviewSection
extends AbstractJvmPropertySection {
    private static final String sectionName = "OverviewSectionTreeExpansionState";
    RefreshAction refreshAction = new RefreshAction(this);
    private Separator separator = new Separator();
    OverviewProperties overviewProperties = new OverviewProperties();
    TreeViewer viewer;

    @Override
    protected void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        IWorkbenchPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IActionBars actionBars = null;
        if (view instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)view;
            actionBars = viewPart.getViewSite().getActionBars();
        }
        this.viewer = new PropertiesFilteredTree(composite, actionBars){
            private ShowInTimelineAction showInTimelineAction;

            @Override
            protected List<Action> createActions(IActionBars actionBars) {
                ArrayList<Action> actions = new ArrayList<Action>();
                CopyAction copyAction = CopyAction.createCopyAction(actionBars);
                actions.add(copyAction);
                this.showInTimelineAction = new MyShowInTimelineAction(OverviewSection.this);
                actions.add(this.showInTimelineAction);
                return actions;
            }

            @Override
            public void menuAboutToshow() {
            }
        }.getViewer();
        this.viewer.setContentProvider((IContentProvider)new OverviewContentProvider(this.overviewProperties));
        this.viewer.setLabelProvider((IBaseLabelProvider)new OverviewLabelProvider());
        ((Tree)this.viewer.getControl()).addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                OverviewSection.this.storeTreeExpansionState();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.fusesource.ide.jvmmonitor.ui.overview_page_content");
    }

    @Override
    protected void setInput(IWorkbenchPart part, ISelection selection, IActiveJvm newJvm, IActiveJvm oldJvm) {
        this.viewer.setInput((Object)newJvm);
    }

    public void refresh() {
        if (!this.isSectionActivated) {
            return;
        }
        new RefreshJob(NLS.bind((String)Messages.refreshOverviewSectionJobLabel, (Object)this.getJvm().getPid()), ((Object)((Object)this)).toString()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                IActiveJvm jvm = OverviewSection.this.getJvm();
                if (jvm != null && jvm.isConnected() && !OverviewSection.this.isRefreshSuspended()) {
                    OverviewSection.this.overviewProperties.refresh(jvm);
                }
            }

            @Override
            protected void refreshUI() {
                IActiveJvm jvm = OverviewSection.this.getJvm();
                boolean isConnected = jvm != null && jvm.isConnected();
                OverviewSection.this.refreshAction.setEnabled(isConnected);
                if (!OverviewSection.this.viewer.getControl().isDisposed()) {
                    OverviewSection.this.refreshBackground(OverviewSection.this.viewer.getControl(), jvm != null && jvm.isConnected());
                    OverviewSection.this.viewer.refresh();
                }
            }
        }.schedule();
    }

    @Override
    protected void addToolBarActions(IToolBarManager manager) {
        manager.insertAfter("defaults", (IContributionItem)this.separator);
        if (manager.find(this.refreshAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.refreshAction);
        }
    }

    @Override
    protected void removeToolBarActions(IToolBarManager manager) {
        manager.remove((IContributionItem)this.separator);
        manager.remove(this.refreshAction.getId());
    }

    @Override
    protected void activateSection() {
        super.activateSection();
        this.restoreTreeExpansionState();
    }

    @Override
    protected void deactivateSection() {
        super.deactivateSection();
        this.storeTreeExpansionState();
        Job.getJobManager().cancel((Object)((Object)((Object)this)).toString());
        IToolBarManager manager = this.getActionBars().getToolBarManager();
        this.removeToolBarActions(manager);
    }

    private void restoreTreeExpansionState() {
        TreeItem[] items = ((Tree)this.viewer.getControl()).getItems();
        this.restoreTreeExpansionState(items);
    }

    private void restoreTreeExpansionState(TreeItem[] items) {
        IDialogSettings settings = this.getDialogSettings();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getItems().length > 0) {
                boolean expanded = settings.getBoolean(item.getText());
                item.setExpanded(expanded);
            }
            ++n2;
        }
    }

    void storeTreeExpansionState() {
        Tree tree = (Tree)this.viewer.getControl();
        if (tree.isDisposed()) {
            return;
        }
        this.storeTreeExpansionState(tree.getItems());
    }

    private void storeTreeExpansionState(TreeItem[] items) {
        IDialogSettings settings = this.getDialogSettings();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getItems().length > 0) {
                settings.put(item.getText(), item.getExpanded());
                this.storeTreeExpansionState(item.getItems());
            }
            ++n2;
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings;
        IDialogSettings section;
        String id = sectionName;
        IActiveJvm jvm = this.getJvm();
        if (jvm != null) {
            id = String.valueOf(id) + jvm.getPid();
        }
        if ((section = (settings = Activator.getDefault().getDialogSettings()).getSection(id)) == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    private static class MyShowInTimelineAction
    extends ShowInTimelineAction {
        public MyShowInTimelineAction(AbstractJvmPropertySection section) {
            super(section);
        }

        @Override
        public MBeanAttribute getMBeanAttribute(Object element) {
            ObjectName objectName;
            if (!(element instanceof OverviewProperty)) {
                return null;
            }
            OverviewProperty property = (OverviewProperty)element;
            try {
                objectName = new ObjectName(property.getObjectName());
            }
            catch (MalformedObjectNameException e) {
                Activator.log(4, Messages.getObjectNameFailedMsg, e);
                return null;
            }
            catch (NullPointerException e) {
                Activator.log(4, Messages.getObjectNameFailedMsg, e);
                return null;
            }
            String attributeName = property.getAttributeName();
            return new MBeanAttribute(objectName, attributeName, this.getRGB(attributeName));
        }

        @Override
        protected boolean getEnabled(Object element) {
            if (!(element instanceof OverviewProperty)) {
                return false;
            }
            OverviewProperty property = (OverviewProperty)element;
            return property.isTimelineSupported();
        }

        private RGB getRGB(String string) {
            int hashCode = string.hashCode();
            int r = (hashCode >> 3) % 256;
            int g = (hashCode >> 1) % 256;
            int b = hashCode % 256;
            return new RGB(Math.abs(r), Math.abs(g), Math.abs(b));
        }
    }
}

