/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.thread;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PatternFilter;
import org.fusesource.ide.commons.ui.IConfigurableColumns;
import org.fusesource.ide.commons.ui.Trees;
import org.fusesource.ide.commons.ui.actions.ConfigureColumnsAction;
import org.fusesource.ide.commons.ui.config.ColumnConfiguration;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ConfigurableFilteredTree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadColumn;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadComparator;

public class ThreadFilteredTree
extends ConfigurableFilteredTree {
    ConfigureColumnsAction configureColumnsAction;

    protected ThreadFilteredTree(Composite parent, IActionBars actionBars) {
        super(parent, 65538, new PatternFilter(), true);
        this.createContextMenu(actionBars);
        this.setBackground(Display.getDefault().getSystemColor(1));
    }

    protected void createControl(Composite composite, int treeStyle) {
        super.createControl(composite, treeStyle);
        GridData data = (GridData)this.filterComposite.getLayoutData();
        data.horizontalIndent = 2;
        data.verticalIndent = 2;
        this.filterComposite.setLayoutData((Object)data);
    }

    public List<String> getColumns() {
        ThreadColumn[] values;
        ArrayList<String> columnLabels = new ArrayList<String>();
        ThreadColumn[] threadColumnArray = values = ThreadColumn.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadColumn value = threadColumnArray[n2];
            columnLabels.add(value.label);
            ++n2;
        }
        return columnLabels;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean getDefaultVisibility(String column) {
        return true;
    }

    @Override
    protected void configureTree() {
        Trees.disposeColumns((TreeViewer)this.getViewer());
        this.getViewer().getTree().setLinesVisible(true);
        this.getViewer().getTree().setHeaderVisible(true);
        List columns = this.getConfiguration().getColumnConfigurations();
        for (ColumnConfiguration config : columns) {
            if (!config.isVisible()) continue;
            ThreadColumn column = ThreadColumn.getColumn(config.getName());
            TreeColumn treeColumn = new TreeColumn(this.getViewer().getTree(), 0);
            treeColumn.setText(column.label);
            treeColumn.setWidth(column.defalutWidth);
            treeColumn.setAlignment(column.initialAlignment);
            treeColumn.setToolTipText(column.toolTip);
            treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof TreeColumn) {
                        ThreadFilteredTree.this.sortColumn((TreeColumn)e.widget);
                    }
                }
            });
        }
        this.getConfiguration().addColumnListeners(this.getViewer());
    }

    void sortColumn(TreeColumn treeColumn) {
        int columnIndex = this.getViewer().getTree().indexOf(treeColumn);
        ThreadComparator sorter = (ThreadComparator)this.getViewer().getComparator();
        if (sorter != null && columnIndex == sorter.getColumnIndex()) {
            sorter.reverseSortDirection();
        } else {
            sorter = new ThreadComparator(columnIndex);
            this.getViewer().setComparator((ViewerComparator)sorter);
        }
        this.getViewer().getTree().setSortColumn(treeColumn);
        this.getViewer().getTree().setSortDirection(sorter.getSortDirection());
        this.getViewer().refresh();
    }

    private void createContextMenu(IActionBars actionBars) {
        this.configureColumnsAction = new ConfigureColumnsAction((IConfigurableColumns)this);
        final CopyAction copyAction = CopyAction.createCopyAction(actionBars);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)copyAction);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)copyAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ThreadFilteredTree.this.configureColumnsAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
    }
}

