/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.fusesource.ide.jvmmonitor.internal.ui.IConstants;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public abstract class AbstractChartSetAction
extends Action
implements IConstants {
    static final String OVERVIEW_CHART_SET = "Overview";
    static final String MEMORY_CHART_SET = "Memory";
    AbstractJvmPropertySection section;

    public AbstractChartSetAction(AbstractJvmPropertySection section) {
        this.setId(this.getClass().getName());
        this.section = section;
    }

    IMemento getChartSetsMemento() throws WorkbenchException, IOException {
        String chartSetsString = Activator.getDefault().getPreferenceStore().getString("ChartSets");
        if (chartSetsString.isEmpty()) {
            return null;
        }
        return XMLMemento.createReadRoot((Reader)new StringReader(chartSetsString));
    }

    List<String> getChartSets() throws WorkbenchException, IOException {
        ArrayList<String> elements = new ArrayList<String>();
        IMemento chartSetsMemento = this.getChartSetsMemento();
        if (chartSetsMemento == null) {
            return elements;
        }
        IMemento[] iMementoArray = chartSetsMemento.getChildren("ChartSet");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento element = iMementoArray[n2];
            elements.add(element.getID());
            ++n2;
        }
        Collections.sort(elements);
        return elements;
    }

    List<String> getPredefinedChartSets() {
        return Arrays.asList(OVERVIEW_CHART_SET, MEMORY_CHART_SET);
    }
}

