/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.TimelineChart;

public class DeleteChartAction
extends Action {
    private TimelineChart chart;
    private AbstractJvmPropertySection section;

    public DeleteChartAction(TimelineChart chart, AbstractJvmPropertySection section) {
        this.chart = chart;
        this.section = section;
        this.setText(Messages.deleteChartLabel);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm == null) {
            return;
        }
        if (MessageDialog.openConfirm((Shell)this.chart.getShell(), (String)Messages.confirmDeleteChartTitle, (String)NLS.bind((String)Messages.confirmDeleteChartMsg, (Object)this.chart.getSection().getText()))) {
            jvm.getMBeanServer().removeMonitoredAttributeGroup(this.chart.getAttributeGroup().getName());
        }
    }
}

