/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;

public class LoadChartSetDialog
extends Dialog {
    TableViewer chartSetViewer;
    Button deleteButton;
    Button makeDefaultButton;
    List<String> chartSets;
    String chartSet;
    String defaultChartSet;
    List<String> predefinedChartSets;

    protected LoadChartSetDialog(Shell shell, List<String> chartSets, String defaultChartSet, List<String> predefinedChartSets) {
        super(shell);
        this.chartSets = chartSets;
        this.chartSet = defaultChartSet;
        this.defaultChartSet = defaultChartSet;
        this.predefinedChartSets = predefinedChartSets;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.loadChartSetDialogTitle);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.fusesource.ide.jvmmonitor.ui.load_chart_set_dialog_content");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(Messages.selectChartSetLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.createChartSetList(container);
        LoadChartSetDialog.applyDialogFont((Control)container);
        return container;
    }

    protected boolean isResizable() {
        return true;
    }

    protected List<String> getChartSets() {
        return this.chartSets;
    }

    protected String getChartSet() {
        return this.chartSet;
    }

    protected String getDefaultChartSet() {
        return this.defaultChartSet;
    }

    private void createChartSetList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.existingChartSetsLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.chartSetViewer = this.createChartSetViewer(composite);
        this.createButtons(composite);
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        this.createDeleteButton(composite);
        this.createMakeDefaultButton(composite);
    }

    private void createDeleteButton(Composite parent) {
        this.deleteButton = new Button(parent, 8);
        this.deleteButton.setText(Messages.deleteButtonLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.deleteButton.setLayoutData((Object)gridData);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LoadChartSetDialog.this.chartSetViewer.getSelection();
                String element = (String)selection.getFirstElement();
                LoadChartSetDialog.this.chartSets.remove(element);
                LoadChartSetDialog.this.chartSetViewer.setInput((Object)LoadChartSetDialog.this.chartSets.toArray(new String[LoadChartSetDialog.this.chartSets.size()]));
            }
        });
    }

    private void createMakeDefaultButton(Composite parent) {
        this.makeDefaultButton = new Button(parent, 8);
        this.makeDefaultButton.setText(Messages.makeDefaultButtonLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.makeDefaultButton.setLayoutData((Object)gridData);
        this.makeDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LoadChartSetDialog.this.chartSetViewer.getSelection();
                LoadChartSetDialog.this.defaultChartSet = (String)selection.getFirstElement();
                LoadChartSetDialog.this.chartSetViewer.refresh();
            }
        });
    }

    private TableViewer createChartSetViewer(Composite parent) {
        final TableViewer viewer = new TableViewer(parent, 67584);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        viewer.getTable().setLayoutData((Object)gridData);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element.equals(LoadChartSetDialog.this.defaultChartSet)) {
                    return NLS.bind((String)Messages.defaultChartSet, (Object)LoadChartSetDialog.this.defaultChartSet);
                }
                return super.getText(element);
            }
        });
        viewer.setInput((Object)this.chartSets.toArray(new String[this.chartSets.size()]));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Object element = ((StructuredSelection)selection).getFirstElement();
                if (LoadChartSetDialog.this.deleteButton != null) {
                    LoadChartSetDialog.this.deleteButton.setEnabled(!selection.isEmpty() && !LoadChartSetDialog.this.predefinedChartSets.contains(element));
                }
                if (element != null) {
                    LoadChartSetDialog.this.chartSet = element.toString();
                } else {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)LoadChartSetDialog.this.chartSet));
                }
            }
        });
        viewer.setSelection((ISelection)new StructuredSelection((Object)this.defaultChartSet));
        return viewer;
    }
}

