/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.ConfigureChartDialog;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class NewChartAction
extends Action {
    AbstractJvmPropertySection section;

    public NewChartAction(AbstractJvmPropertySection section) {
        this.setText(Messages.newChartLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/new_chart.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/full/dlcl16/new_chart.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.section = section;
    }

    public void run() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm == null) {
            return;
        }
        NewChartDialog dialog = new NewChartDialog(Display.getDefault().getActiveShell(), jvm);
        if (dialog.open() == 0) {
            this.performNew(dialog.getChartTitle(), dialog.getAxisUnit(), dialog.getAttributes(), jvm);
        }
    }

    private void performNew(String chartTitle, IMonitoredMXBeanGroup.AxisUnit axisUnit, List<MBeanAttribute> attributes, IActiveJvm jvm) {
        IMonitoredMXBeanGroup group = jvm.getMBeanServer().addMonitoredAttributeGroup(chartTitle, axisUnit);
        for (MBeanAttribute attribute : attributes) {
            ObjectName objectName = attribute.getObjectName();
            String attributeName = attribute.getAttributeName();
            RGB rgb = attribute.getRgb();
            try {
                group.addAttribute(objectName.getCanonicalName(), attributeName, new int[]{rgb.red, rgb.green, rgb.blue});
            }
            catch (JvmCoreException e) {
                Activator.log(Messages.addAttributeFailedMsg, (CoreException)((Object)e));
            }
        }
    }

    private static class NewChartDialog
    extends ConfigureChartDialog {
        protected NewChartDialog(Shell shell, IActiveJvm jvm) {
            super(shell, "", null, new ArrayList<MBeanAttribute>(), jvm, true);
        }

        @Override
        public void create() {
            super.create();
            this.getShell().setText(Messages.newChartDialogTitle);
        }

        @Override
        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.fusesource.ide.jvmmonitor.ui.new_chart_dialog_content");
        }
    }
}

