/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.IHost;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.core.JvmModel;
import org.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.views.NewJvmConnectionWizardPage;
import org.fusesource.ide.jvmmonitor.internal.ui.views.StartMonitoringAction;
import org.fusesource.ide.jvmmonitor.ui.Activator;
import org.fusesource.ide.jvmmonitor.ui.JvmMonitorPreferences;

public class NewJvmConnectionWizard
extends Wizard
implements INewWizard {
    private NewJvmConnectionWizardPage page;
    private TreeViewer viewer;

    public NewJvmConnectionWizard(TreeViewer viewer) {
        this.viewer = viewer;
        this.setDialogSettings(Activator.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.newJvmConnectionTitle);
    }

    public void addPages() {
        this.page = new NewJvmConnectionWizardPage(this.viewer.getSelection());
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IActiveJvm jvm = this.addActiveJvm();
        if (jvm == null) {
            return false;
        }
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)jvm));
        StartMonitoringAction action = new StartMonitoringAction();
        action.showPropertiesView(jvm);
        try {
            int period = JvmMonitorPreferences.getJvmUpdatePeriod();
            jvm.connect(period);
        }
        catch (JvmCoreException e) {
            Activator.log(NLS.bind((String)Messages.connectJvmFailedMsg, (Object)jvm.getPid()), (CoreException)((Object)e));
        }
        this.page.storeDialogSettings();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private IActiveJvm addActiveJvm() {
        final boolean isHostAndPortSelected = this.page.isHostAndPortSelected();
        final String hostName = this.page.getRemoteHost();
        final int port = this.page.getPort();
        final String userName = this.page.getUserName();
        final String password = this.page.getPassword();
        final String jmxUrl = this.page.getJmxUrl();
        try {
            final IActiveJvm[] result = new IActiveJvm[1];
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        int period = JvmMonitorPreferences.getJvmUpdatePeriod();
                        if (isHostAndPortSelected) {
                            IHost host = JvmModel.getInstance().addHost(hostName);
                            result[0] = host.addRemoteActiveJvm(port, userName, password, period);
                        } else {
                            result[0] = JvmModel.getInstance().addHostAndJvm(jmxUrl, userName, password, period);
                        }
                    }
                    catch (JvmCoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            return result[0];
        }
        catch (InvocationTargetException e) {
            this.openErrorDialog(e);
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private void openErrorDialog(final InvocationTargetException e) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)NewJvmConnectionWizard.this.getShell(), (String)"Error", (String)NewJvmConnectionWizard.this.getErrorMessage(e));
            }
        });
    }

    String getErrorMessage(InvocationTargetException e) {
        Throwable rootCause = e;
        while (((Throwable)rootCause).getCause() != null && rootCause != ((Throwable)rootCause).getCause()) {
            rootCause = ((Throwable)rootCause).getCause();
        }
        if (rootCause instanceof UnknownHostException) {
            return Messages.determineIpAddressFailedMsg;
        }
        if (rootCause instanceof ConnectException) {
            return Messages.connectionTimedOutMsg;
        }
        return Messages.connectionFailedMsg;
    }
}

