/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.IHost;
import org.fusesource.ide.jvmmonitor.core.IJvm;
import org.fusesource.ide.jvmmonitor.core.JvmModel;
import org.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class NewJvmConnectionWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "newJvmConnectionWizardPage";
    private static final String REMOTE_HOST_HISTORY_KEY = String.valueOf(Activator.getDefault().getBundle().getBundleId()) + ".remoteHost";
    private static final String PORT_HISTORY_KEY = String.valueOf(Activator.getDefault().getBundle().getBundleId()) + ".port";
    private static final String USER_NAME_HISTORY_KEY = String.valueOf(Activator.getDefault().getBundle().getBundleId()) + ".userName";
    private static final String URL_HISTORY_KEY = String.valueOf(Activator.getDefault().getBundle().getBundleId()) + ".url";
    private static final String JMX_URL_HEADER = "service:jmx:";
    Combo remoteHostText;
    Combo portText;
    private Combo userNameText;
    private Text passwordText;
    Combo urlText;
    Button hostAndPortButton;
    private ISelection selection;

    public NewJvmConnectionWizardPage(ISelection selection) {
        super(PAGE_NAME);
        this.selection = selection;
        this.setTitle(Messages.newJvmConnectionPageTitle);
        this.setDescription(Messages.createNewJvmConnectionMsg);
        ImageDescriptor image = Activator.getImageDescriptor("icons/full/wizban/new_jvm_connection_wiz.png");
        this.setImageDescriptor(image);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createConnectionGroup(composite);
        this.createAuthenticateGroup(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.fusesource.ide.jvmmonitor.ui.new_jvm_connection_wizard_page_context");
    }

    protected String getRemoteHost() {
        return this.remoteHostText.getText();
    }

    protected int getPort() {
        try {
            return Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected String getUserName() {
        return this.userNameText.getText();
    }

    protected String getPassword() {
        return this.passwordText.getText();
    }

    protected String getJmxUrl() {
        return this.urlText.getText();
    }

    protected boolean isHostAndPortSelected() {
        return this.hostAndPortButton.getSelection();
    }

    protected void storeDialogSettings() {
        if (this.isHostAndPortSelected()) {
            this.addItemToDialogSettings(REMOTE_HOST_HISTORY_KEY, this.getRemoteHost());
            this.addItemToDialogSettings(PORT_HISTORY_KEY, String.valueOf(this.getPort()));
        } else {
            this.addItemToDialogSettings(URL_HISTORY_KEY, String.valueOf(this.getJmxUrl()));
        }
        this.addItemToDialogSettings(USER_NAME_HISTORY_KEY, String.valueOf(this.getUserName()));
    }

    private void createConnectionGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.connectionGroupLabel);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        this.createHostAndPortPanel((Composite)group);
        this.createUrlPanel((Composite)group);
    }

    private void createAuthenticateGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.authenticateGroupLabel);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        this.userNameText = this.addComboTextField((Composite)group, Messages.userNameTextLabel, USER_NAME_HISTORY_KEY);
        this.passwordText = this.addTextField((Composite)group, Messages.passwordTextLabel);
        this.passwordText.setEchoChar('*');
    }

    private void createHostAndPortPanel(Composite parent) {
        this.hostAndPortButton = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.hostAndPortButton.setLayoutData((Object)layoutData);
        this.hostAndPortButton.setText(Messages.connectWithHostAndPort);
        this.hostAndPortButton.setSelection(true);
        this.hostAndPortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!NewJvmConnectionWizardPage.this.hostAndPortButton.getSelection()) {
                    return;
                }
                NewJvmConnectionWizardPage.this.urlText.setEnabled(false);
                NewJvmConnectionWizardPage.this.remoteHostText.setEnabled(true);
                NewJvmConnectionWizardPage.this.remoteHostText.setFocus();
                NewJvmConnectionWizardPage.this.portText.setEnabled(true);
                NewJvmConnectionWizardPage.this.validate();
            }
        });
        this.remoteHostText = this.addComboTextField(parent, Messages.remoteHostTextLabel, REMOTE_HOST_HISTORY_KEY);
        List hosts = JvmModel.getInstance().getHosts();
        for (IHost host : hosts) {
            String hostName = host.getName();
            if (hostName.equals("localhost") || this.remoteHostText.indexOf(hostName) != -1) continue;
            this.remoteHostText.add(hostName);
        }
        this.remoteHostText.setFocus();
        String hostName = this.getSelectedHost();
        if (hostName != null && !"localhost".equals(hostName)) {
            this.remoteHostText.setText(hostName);
        }
        this.portText = this.addComboTextField(parent, Messages.portTextLabel, PORT_HISTORY_KEY);
    }

    private void createUrlPanel(Composite parent) {
        Button urlButton = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        urlButton.setLayoutData((Object)layoutData);
        urlButton.setText(Messages.connectWithJmxUrl);
        urlButton.setSelection(false);
        urlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewJvmConnectionWizardPage.this.hostAndPortButton.getSelection()) {
                    return;
                }
                NewJvmConnectionWizardPage.this.remoteHostText.setEnabled(false);
                NewJvmConnectionWizardPage.this.portText.setEnabled(false);
                NewJvmConnectionWizardPage.this.urlText.setEnabled(true);
                if (NewJvmConnectionWizardPage.this.urlText.getText().isEmpty()) {
                    NewJvmConnectionWizardPage.this.urlText.setText(NewJvmConnectionWizardPage.JMX_URL_HEADER);
                }
                NewJvmConnectionWizardPage.this.urlText.setFocus();
                NewJvmConnectionWizardPage.this.validate();
            }
        });
        this.urlText = this.addComboTextField(parent, Messages.jmxUrlTextLabel, URL_HISTORY_KEY);
        this.urlText.setEnabled(false);
    }

    private String getSelectedHost() {
        if (this.selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)this.selection).getFirstElement();
            if (element instanceof IHost) {
                return ((IHost)element).getName();
            }
            if (element instanceof IJvm) {
                return ((IJvm)element).getHost().getName();
            }
        }
        return null;
    }

    private void addItemToDialogSettings(String key, String item) {
        String[] items = this.getDialogSettings().getArray(key);
        if (items == null) {
            items = new String[]{item};
        } else {
            ArrayList<String> list = new ArrayList<String>();
            Collections.addAll(list, items);
            if (list.contains(item)) {
                list.remove(item);
            }
            Collections.reverse(list);
            list.add(item);
            Collections.reverse(list);
            items = list.toArray(new String[0]);
        }
        this.getDialogSettings().put(key, items);
    }

    private Combo addComboTextField(Composite composite, String labelString, String historyKey) {
        Label label = new Label(composite, 0);
        label.setText(labelString);
        Combo combo = new Combo(composite, 2048);
        String[] items = this.getDialogSettings().getArray(historyKey);
        if (items != null) {
            combo.setItems(items);
        }
        combo.setLayoutData((Object)new GridData(4, 0, true, false));
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJvmConnectionWizardPage.this.validate();
            }
        });
        return combo;
    }

    private Text addTextField(Composite composite, String labelString) {
        Label label = new Label(composite, 0);
        label.setText(labelString);
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJvmConnectionWizardPage.this.validate();
            }
        });
        return text;
    }

    void validate() {
        if (this.hostAndPortButton == null || this.portText == null) {
            return;
        }
        String errorMsg = null;
        if (this.hostAndPortButton.getSelection()) {
            if (this.getRemoteHost().isEmpty()) {
                errorMsg = Messages.emptyRemoteHostNameMsg;
            } else if (this.portText.getText().isEmpty()) {
                errorMsg = Messages.emptyPortMsg;
            } else {
                try {
                    if (this.getPort() < 0) {
                        errorMsg = Messages.invalidPortMsg;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    errorMsg = Messages.invalidPortMsg;
                }
            }
        } else if (this.getJmxUrl().isEmpty()) {
            errorMsg = Messages.emptyJmxUrlMsg;
        } else if (!this.getJmxUrl().startsWith(JMX_URL_HEADER)) {
            errorMsg = Messages.invalidJmxUrlHeaderMsg;
        } else if (this.getJmxUrl().equals(JMX_URL_HEADER)) {
            errorMsg = Messages.invalidJmxUrlMsg;
        }
        this.setErrorMessage(errorMsg);
        this.setPageComplete(errorMsg == null);
    }
}

