/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.fusesource.ide.jvmmonitor.core.ISnapshot;
import org.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class OpenSnapshotAction
extends Action
implements ISelectionChangedListener {
    private List<ISnapshot> snapshots;
    private boolean visible;

    public OpenSnapshotAction() {
        this.setText(Messages.openSnapshotLabel);
        this.snapshots = new ArrayList<ISnapshot>();
        this.visible = false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof TreeSelection)) {
            return;
        }
        this.snapshots.clear();
        this.visible = false;
        Object[] objectArray = ((TreeSelection)event.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!(element instanceof ISnapshot)) {
                this.visible = false;
                this.snapshots.clear();
                break;
            }
            this.snapshots.add((ISnapshot)element);
            this.visible = true;
            ++n2;
        }
        this.setEnabled(this.snapshots.size() > 0);
    }

    public void run() {
        for (ISnapshot snapshot : this.snapshots) {
            OpenSnapshotAction.openEditor(snapshot.getFileStore());
        }
    }

    public static void openEditor(final IFileStore fileStore) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)fileStore);
                }
                catch (PartInitException e) {
                    Activator.log(4, null, e);
                }
            }
        });
    }

    protected boolean getVisible() {
        return this.visible;
    }
}

