/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.fusesource.ide.jvmmonitor.core.ISnapshot;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class RenameAction
extends Action
implements ISelectionChangedListener {
    private ISnapshot snapshot;
    private TreeViewer treeViewer;

    public RenameAction(TreeViewer treeViewer, IActionBars actionBars) {
        this.treeViewer = treeViewer;
        this.setText(Messages.renameLabel);
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof TreeSelection)) {
            return;
        }
        this.snapshot = null;
        ArrayList<ISnapshot> snapshots = new ArrayList<ISnapshot>();
        Object[] objectArray = ((TreeSelection)event.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!(element instanceof ISnapshot)) {
                snapshots.clear();
                break;
            }
            snapshots.add((ISnapshot)element);
            ++n2;
        }
        boolean enabled = snapshots.size() == 1;
        this.setEnabled(enabled);
        if (enabled) {
            this.snapshot = (ISnapshot)snapshots.get(0);
        }
    }

    public void run() {
        String newName = this.getNewName();
        if (newName != null) {
            this.closeEditor();
            try {
                this.snapshot.rename(newName);
            }
            catch (JvmCoreException e) {
                ErrorDialog.openError((Shell)this.treeViewer.getTree().getShell(), (String)Messages.errorDialogTitle, (String)Messages.renameFailedMsg, (IStatus)e.getStatus());
            }
            this.treeViewer.refresh();
        }
    }

    private void closeEditor() {
        IEditorReference[] references;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor;
            IEditorReference reference = iEditorReferenceArray[n2];
            if (reference.getTitle().equals(this.snapshot.getFileStore().getName()) && (editor = reference.getEditor(false)) != null) {
                page.closeEditor(editor, false);
            }
            ++n2;
        }
    }

    private String getNewName() {
        String oldName;
        IFileStore fileStore = this.snapshot.getFileStore();
        ArrayList<String> oldNames = new ArrayList<String>();
        try {
            String[] stringArray = fileStore.getParent().childNames(0, null);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                oldName = stringArray[n2];
                oldNames.add(this.removeSuffix(oldName));
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log(4, NLS.bind((String)Messages.accessFileFailedMsg, (Object)fileStore.getName()), e);
            return null;
        }
        oldName = fileStore.getName();
        InputValidator validator = new InputValidator(oldNames, oldName);
        InputDialog dialog = new InputDialog(this.treeViewer.getControl().getShell(), Messages.renameTitle, Messages.newNameLabel, this.removeSuffix(oldName), (IInputValidator)validator);
        if (dialog.open() == 0) {
            return oldName.replace(this.removeSuffix(oldName), dialog.getValue());
        }
        return null;
    }

    private String removeSuffix(String fileName) {
        return fileName.substring(0, fileName.indexOf(46));
    }

    private static class InputValidator
    implements IInputValidator {
        private static final char[] INVALID_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        private List<String> oldNames;
        private String oldName;

        public InputValidator(List<String> oldNames, String oldName) {
            this.oldNames = oldNames;
            this.oldName = oldName;
        }

        public String isValid(String newText) {
            if (newText.isEmpty()) {
                return "";
            }
            for (String name : this.oldNames) {
                if (!name.equals(newText) || name.equals(this.oldName)) continue;
                return Messages.fileAlreadyExistsMsg;
            }
            char[] cArray = INVALID_CHARACTERS;
            int n = INVALID_CHARACTERS.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (newText.indexOf(c) != -1) {
                    return Messages.fileContainsInvalidCharactersMsg;
                }
                ++n2;
            }
            return null;
        }
    }
}

