/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import org.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class StopMonitoringAction
extends Action
implements ISelectionChangedListener {
    List<IActiveJvm> jvms;
    TreeViewer treeViewer;
    private boolean visible;

    public StopMonitoringAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.jvms = new ArrayList<IActiveJvm>();
        this.visible = false;
        this.setText(Messages.stopMonitoringLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/disconnect.png"));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof TreeSelection)) {
            return;
        }
        this.jvms.clear();
        this.visible = false;
        Object[] objectArray = ((TreeSelection)event.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!(element instanceof IActiveJvm)) {
                this.visible = false;
                this.jvms.clear();
                break;
            }
            this.jvms.add((IActiveJvm)element);
            this.visible = true;
            ++n2;
        }
        this.refresh();
    }

    public void run() {
        RefreshJob refreshJob = new RefreshJob(Messages.stopMonitoringJobLabel, UUID.randomUUID().toString()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                for (IActiveJvm jvm : StopMonitoringAction.this.jvms) {
                    jvm.disconnect();
                }
            }

            @Override
            protected void refreshUI() {
                if (!StopMonitoringAction.this.treeViewer.getControl().isDisposed()) {
                    StopMonitoringAction.this.treeViewer.refresh();
                }
            }
        };
        refreshJob.schedule();
    }

    protected void refresh() {
        boolean enable = true;
        for (IActiveJvm jvm : this.jvms) {
            if (jvm.isConnected() && jvm.isConnectionSupported()) continue;
            enable = false;
        }
        this.setEnabled(enable);
    }

    protected boolean getVisible() {
        return this.visible;
    }
}

