/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.core.dump;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import org.fusesource.ide.jvmmonitor.core.dump.AbstractDumpParser;
import org.fusesource.ide.jvmmonitor.internal.core.cpu.CpuDumpSaxEventHandler;
import org.fusesource.ide.jvmmonitor.internal.core.cpu.CpuModel;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CpuDumpParser
extends AbstractDumpParser {
    private InputStream inputStream;
    private CpuModel cpuModel;
    private InputType inputType;

    public CpuDumpParser(File file, ICpuModel cpuModel, IProgressMonitor monitor) {
        this(cpuModel, monitor);
        Assert.isNotNull((Object)file);
        this.file = file;
        this.inputType = InputType.FILE;
    }

    public CpuDumpParser(InputStream inputStream, ICpuModel cpuModel, IProgressMonitor monitor) {
        this(cpuModel, monitor);
        Assert.isNotNull((Object)inputStream);
        this.inputStream = inputStream;
        this.inputType = InputType.STREAM;
    }

    private CpuDumpParser(ICpuModel cpuModel, IProgressMonitor monitor) {
        super(monitor);
        Assert.isNotNull((Object)cpuModel);
        this.cpuModel = (CpuModel)cpuModel;
    }

    public void parse() throws ParserConfigurationException, SAXException, IOException {
        this.parser = SAXParserFactory.newInstance().newSAXParser();
        CpuDumpSaxEventHandler handler = new CpuDumpSaxEventHandler(this.cpuModel, this.monitor);
        if (this.inputType == InputType.FILE) {
            if (this.file.exists() && this.file.canRead()) {
                this.parser.parse(this.file, (DefaultHandler)handler);
            }
        } else if (this.inputType == InputType.STREAM) {
            this.parser.parse(this.inputStream, (DefaultHandler)handler);
        }
        this.info = handler.getProfileInfo();
    }

    private static enum InputType {
        STREAM,
        FILE;

    }
}

