/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ObjectName;
import org.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanAttribute;

public class MonitoredMXBeanAttribute
implements IMonitoredMXBeanAttribute {
    private static final long NUM_OF_DURATIONS = 500L;
    private ObjectName objectName;
    private String atributeName;
    private List<Number> values;
    private List<Date> dates;
    private int previousDurationIndex;
    private int[] rgb;

    public MonitoredMXBeanAttribute(ObjectName objectName, String attributeName, int[] rgb) {
        this.objectName = objectName;
        this.atributeName = attributeName;
        this.previousDurationIndex = 0;
        this.rgb = rgb;
        this.values = new CopyOnWriteArrayList<Number>();
        this.dates = new CopyOnWriteArrayList<Date>();
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getAttributeName() {
        return this.atributeName;
    }

    @Override
    public int[] getRGB() {
        return this.rgb;
    }

    @Override
    public List<Date> getDates() {
        return this.dates;
    }

    @Override
    public List<Number> getValues() {
        return this.values;
    }

    @Override
    public void setRGB(int r, int g, int b) {
        this.rgb = new int[]{r, g, b};
    }

    @Override
    public void clear() {
        this.dates.clear();
        this.values.clear();
        this.previousDurationIndex = 0;
    }

    public void add(Number value, Date date) {
        this.values.add(value);
        this.dates.add(date);
        if ((long)this.dates.size() > 1000L) {
            this.compress();
        }
    }

    public int getSize() {
        return this.dates.size();
    }

    private void compress() {
        ArrayList<Date> compressedDates = new ArrayList<Date>();
        ArrayList<Number> compressedValues = new ArrayList<Number>();
        int minIndex = 0;
        int maxIndex = 0;
        this.previousDurationIndex = 0;
        int i = 0;
        while (i < this.dates.size()) {
            if (this.isInSameDurationAsPrevious(this.dates.get(i).getTime())) {
                double value = this.values.get(i).doubleValue();
                if (value > this.values.get(maxIndex).doubleValue()) {
                    maxIndex = i;
                }
                if (value < this.values.get(minIndex).doubleValue()) {
                    minIndex = i;
                }
            } else {
                this.addValues(compressedDates, compressedValues, minIndex, maxIndex);
                maxIndex = i;
                minIndex = i;
            }
            ++i;
        }
        this.addValues(compressedDates, compressedValues, minIndex, maxIndex);
        this.dates = compressedDates;
        this.values = compressedValues;
    }

    private void addValues(ArrayList<Date> datesArray, ArrayList<Number> valuesArray, int indexA, int indexB) {
        if (indexA < indexB) {
            datesArray.add(this.dates.get(indexA));
            valuesArray.add(this.values.get(indexA));
            datesArray.add(this.dates.get(indexB));
            valuesArray.add(this.values.get(indexB));
        } else if (indexA > indexB) {
            datesArray.add(this.dates.get(indexB));
            valuesArray.add(this.values.get(indexB));
            datesArray.add(this.dates.get(indexA));
            valuesArray.add(this.values.get(indexA));
        } else {
            datesArray.add(this.dates.get(indexB));
            valuesArray.add(this.values.get(indexB));
        }
    }

    private boolean isInSameDurationAsPrevious(long date) {
        double maxDate;
        double minDate = this.dates.get(0).getTime();
        int durationIndex = (int)(((double)date - minDate) / ((maxDate = (double)this.dates.get(this.dates.size() - 1).getTime()) - minDate) * 500.0);
        boolean isInSameGridAsPrevious = durationIndex == this.previousDurationIndex;
        this.previousDurationIndex = durationIndex;
        return isInSameGridAsPrevious;
    }
}

