/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.jvmmonitor.core.IJvm;
import org.fusesource.ide.jvmmonitor.core.ISnapshot;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.core.AbstractJvm;
import org.fusesource.ide.jvmmonitor.internal.core.Messages;

public class Snapshot
implements ISnapshot {
    private ISnapshot.SnapshotType snapshotType;
    private IJvm jvm;
    private IFileStore fileStore;
    private String timeStamp;

    public Snapshot(IFileStore fileStore, IJvm jvm) {
        this.fileStore = fileStore;
        this.jvm = jvm;
        this.parseFileName(fileStore.getName());
    }

    @Override
    public IFileStore getFileStore() {
        return this.fileStore;
    }

    @Override
    public IJvm getJvm() {
        return this.jvm;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getTimeStamp() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ISnapshot.SnapshotType getType() {
        return this.snapshotType;
    }

    @Override
    public void rename(String newName) throws JvmCoreException {
        String newFilePath;
        File destFile;
        File file = new File(this.fileStore.toURI());
        if (file.renameTo(destFile = new File(newFilePath = String.valueOf(this.fileStore.getParent().toURI().getPath()) + File.separator + newName))) {
            if (this.jvm instanceof AbstractJvm) {
                ((AbstractJvm)this.jvm).refreshSnapshots();
            }
        } else {
            throw new JvmCoreException(4, NLS.bind((String)Messages.renameFileFailedMsg, (Object)this.fileStore.toURI().getPath()), null);
        }
    }

    public String toString() {
        return this.fileStore.getName();
    }

    public static boolean isValidFile(String fileName) {
        String[] elements = fileName.split("\\.");
        if (elements == null || elements.length != 2) {
            return false;
        }
        ISnapshot.SnapshotType[] snapshotTypeArray = ISnapshot.SnapshotType.values();
        int n = snapshotTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISnapshot.SnapshotType type = snapshotTypeArray[n2];
            if (elements[1].equals(type.getExtension())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void parseFileName(String fileName) {
        ISnapshot.SnapshotType[] snapshotTypeArray = ISnapshot.SnapshotType.values();
        int n = snapshotTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISnapshot.SnapshotType type = snapshotTypeArray[n2];
            if (fileName.endsWith(type.getExtension())) {
                this.snapshotType = type;
            }
            ++n2;
        }
    }
}

