/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.jvmmonitor.core.Activator;
import org.fusesource.ide.jvmmonitor.core.Messages;

public class Util {
    public static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    Util.deleteDir(file);
                } else if (!file.delete()) {
                    Activator.log(4, NLS.bind((String)Messages.removeFileFailedMsg, (Object)file.getAbsolutePath()), new Exception());
                }
                ++n2;
            }
        }
        if (!dir.delete()) {
            Activator.log(4, NLS.bind((String)Messages.removeDirectoryFailedMsg, (Object)dir.getAbsolutePath()), new Exception());
        }
    }

    public static Properties loadProperties(IPath filePath) {
        Properties props = new Properties();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(filePath);
        try {
            InputStream in = fileStore.openInputStream(0, null);
            props.loadFromXML(in);
        }
        catch (CoreException e) {
            Activator.log(4, NLS.bind((String)Messages.openInputStreamFailedMsg, (Object)filePath.toOSString()), e);
            return null;
        }
        catch (IOException e) {
            Activator.log(4, NLS.bind((String)Messages.loadPropertiesFileFailedMsg, (Object)filePath.toOSString()), e);
            return null;
        }
        return props;
    }

    public static IFileStore getFileStore(String fileName, IPath baseDir) {
        IPath filePath = baseDir.append(String.valueOf(File.separator) + fileName);
        return EFS.getLocalFileSystem().getStore(filePath);
    }
}

