/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core.cpu;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.fusesource.ide.jvmmonitor.core.Activator;
import org.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import org.fusesource.ide.jvmmonitor.core.cpu.ITreeNode;
import org.fusesource.ide.jvmmonitor.core.dump.IProfileInfo;
import org.fusesource.ide.jvmmonitor.internal.core.ProfileInfo;
import org.fusesource.ide.jvmmonitor.internal.core.cpu.CallTreeNode;
import org.fusesource.ide.jvmmonitor.internal.core.cpu.CpuModel;
import org.fusesource.ide.jvmmonitor.internal.core.cpu.MethodNode;
import org.fusesource.ide.jvmmonitor.internal.core.cpu.ThreadNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CpuDumpSaxEventHandler
extends DefaultHandler {
    private String ILLEGAL_NUMBER_FORMAT = "ERROR: profile result data contains illegal number format.";
    private IProgressMonitor monitor;
    private ThreadNode<CallTreeNode> currentCallTreeThreadNode;
    private ThreadNode<MethodNode> currentHotSpotThreadNode;
    private CallTreeNode currentRootFrameNode;
    private CallTreeNode currentFrameNode;
    private CpuModel cpuModel;
    private long threadTotalTime;
    private long frameTotalTime;
    private IProfileInfo info;

    public CpuDumpSaxEventHandler(CpuModel cpuModel, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.cpuModel = cpuModel;
        this.threadTotalTime = 0L;
        this.frameTotalTime = 0L;
    }

    @Override
    public void startDocument() throws SAXException {
        this.cpuModel.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        this.cpuModel.notifyModelChanged(new CpuModelEvent(CpuModelEvent.CpuModelState.CpuModelChanged));
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if ("cpu-profile".equals(name)) {
            String date = attributes.getValue("date");
            String runtime = attributes.getValue("runtime");
            String mainClass = attributes.getValue("mainClass");
            String arguments = attributes.getValue("arguments");
            String comments = attributes.getValue("comments");
            this.info = new ProfileInfo(date, runtime, mainClass, arguments, comments);
            return;
        }
        if ("thread".equals(name)) {
            String threadName = attributes.getValue("name");
            this.currentCallTreeThreadNode = this.cpuModel.getCallTreeThread(threadName);
            if (this.currentCallTreeThreadNode == null) {
                this.currentCallTreeThreadNode = new ThreadNode(threadName);
                this.cpuModel.addCallTreeThread(this.currentCallTreeThreadNode);
            }
            this.currentHotSpotThreadNode = this.cpuModel.getHotSpotThread(threadName);
            if (this.currentHotSpotThreadNode == null) {
                this.currentHotSpotThreadNode = new ThreadNode(threadName);
                this.cpuModel.addHotSpotThread(this.currentHotSpotThreadNode);
            }
            return;
        }
        if ("frame".equals(name)) {
            this.parseFrame(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("thread".equals(name)) {
            this.currentCallTreeThreadNode.setTotalTime(this.threadTotalTime);
            this.currentCallTreeThreadNode = null;
            this.currentHotSpotThreadNode.setTotalTime(this.threadTotalTime);
            this.currentHotSpotThreadNode = null;
            this.currentRootFrameNode = null;
            this.currentFrameNode = null;
            this.threadTotalTime = 0L;
            return;
        }
        if ("frame".equals(name)) {
            ITreeNode parrentNode = this.currentFrameNode.getParent();
            if (parrentNode instanceof CallTreeNode) {
                CallTreeNode parentFrameNode = (CallTreeNode)parrentNode;
                long selfTime = parentFrameNode.getSelfTime() - this.currentFrameNode.getTotalTime();
                parentFrameNode.setSelfTime(selfTime);
                this.storeMethods(this.currentFrameNode);
                this.currentFrameNode = parentFrameNode;
            } else {
                this.storeMethods(this.currentFrameNode);
                this.currentRootFrameNode.setTotalTime(this.frameTotalTime);
                this.currentRootFrameNode = null;
                this.currentFrameNode = null;
                this.threadTotalTime += this.frameTotalTime;
                this.frameTotalTime = 0L;
            }
        }
    }

    public IProfileInfo getProfileInfo() {
        return this.info;
    }

    private void parseFrame(Attributes attributes) {
        String methodName = attributes.getValue("name");
        int count = Integer.parseInt(attributes.getValue("cnt"));
        long time = Long.parseLong(attributes.getValue("time"));
        if (this.currentRootFrameNode == null) {
            this.currentRootFrameNode = (CallTreeNode)this.currentCallTreeThreadNode.getChild(methodName);
            if (this.currentRootFrameNode == null) {
                this.currentRootFrameNode = new CallTreeNode(this.cpuModel, methodName, time, count, this.currentCallTreeThreadNode);
                this.currentCallTreeThreadNode.addChild(this.currentRootFrameNode);
            } else {
                this.currentRootFrameNode.setTotalTime(time);
                this.currentRootFrameNode.setInvocationCount(count);
            }
            this.currentFrameNode = this.currentRootFrameNode;
            this.frameTotalTime += time;
        } else {
            CallTreeNode childFrameNode = this.currentFrameNode.getChild(methodName);
            if (childFrameNode == null) {
                childFrameNode = new CallTreeNode(this.cpuModel, methodName, time, count, this.currentFrameNode, this.currentCallTreeThreadNode);
                this.currentFrameNode.addChild(childFrameNode);
            } else {
                childFrameNode.setTotalTime(time);
                childFrameNode.setInvocationCount(count);
            }
            this.currentFrameNode = childFrameNode;
        }
        this.currentFrameNode.setSelfTime(time);
    }

    private void storeMethods(CallTreeNode frame) {
        String methodName = frame.getName();
        MethodNode method = (MethodNode)this.currentHotSpotThreadNode.getChild(methodName);
        long time = frame.getSelfTime();
        int count = 0;
        try {
            count = frame.getInvocationCount();
        }
        catch (NumberFormatException e) {
            Activator.log(4, this.ILLEGAL_NUMBER_FORMAT, e);
            return;
        }
        if (method == null) {
            method = new MethodNode((ICpuModel)this.cpuModel, methodName, this.currentHotSpotThreadNode);
            this.currentHotSpotThreadNode.addChild(method);
        }
        method.incrementTime(time);
        method.incrementCount(count);
    }
}

