/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileDefaultSorter;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericFileComponent<T>
extends DefaultComponent {
    protected Log log = LogFactory.getLog(this.getClass());

    public GenericFileComponent() {
    }

    public GenericFileComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected GenericFileEndpoint<T> createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GenericFileEndpoint<T> endpoint = this.buildFileEndpoint(uri, remaining, parameters);
        String sortBy = this.getAndRemoveParameter(parameters, "sortBy", String.class);
        if (ObjectHelper.isNotEmpty(sortBy) && !EndpointHelper.isReferenceParameter(sortBy)) {
            String[] groups = sortBy.split(";");
            Iterator<String> it = CastUtils.cast(ObjectHelper.createIterator(groups));
            Comparator<Exchange> comparator = this.createSortByComparator(it);
            endpoint.setSortBy(comparator);
        }
        this.setProperties(endpoint.getConfiguration(), parameters);
        this.setProperties(endpoint, parameters);
        this.afterPropertiesSet(endpoint);
        return endpoint;
    }

    protected abstract GenericFileEndpoint<T> buildFileEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected abstract void afterPropertiesSet(GenericFileEndpoint<T> var1) throws Exception;

    private Comparator<Exchange> createSortByComparator(Iterator<String> it) {
        if (!it.hasNext()) {
            return null;
        }
        String group = it.next();
        boolean reverse = group.startsWith("reverse:");
        String reminder = reverse ? this.ifStartsWithReturnRemainder("reverse:", group) : group;
        boolean ignoreCase = reminder.startsWith("ignoreCase:");
        reminder = ignoreCase ? this.ifStartsWithReturnRemainder("ignoreCase:", reminder) : reminder;
        ObjectHelper.notEmpty(reminder, "sortBy expression", this);
        return GenericFileDefaultSorter.sortByFileLanguage(this.getCamelContext(), reminder, reverse, ignoreCase, this.createSortByComparator(it));
    }
}

