/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.record.impl;

import com.sap.conn.idoc.rt.record.RecordMetaData;
import com.sap.conn.idoc.rt.record.impl.AbstractMetaData;
import com.sap.conn.idoc.rt.record.impl.AbstractRecord;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceUtils {
    protected static final String CRLF = System.getProperty("line.separator");

    private static StringBuilder dumpMetadata(List<Object> mdsToDump, List<Object> dumpedMds) {
        StringBuilder buf = new StringBuilder();
        while (!mdsToDump.isEmpty()) {
            AbstractMetaData md;
            AbstractRecord r;
            Object o = mdsToDump.remove(0);
            if (o instanceof AbstractMetaData) {
                r = null;
                md = (AbstractMetaData)o;
            } else if (o instanceof AbstractRecord) {
                r = (AbstractRecord)o;
                md = r.metaData;
            } else {
                buf.append("warning unexpected class ").append(o.getClass().getName()).append(CRLF);
                continue;
            }
            buf.append(md.getName()).append(CRLF);
            for (int index = 0; index < md.getFieldCount(); ++index) {
                int c;
                buf.append("   ");
                String str = md.name[index];
                buf.append(str);
                for (c = str.length(); c < 32; ++c) {
                    buf.append(' ');
                }
                str = "-";
                o = md.getRecordTypeName(index);
                if (o != null) {
                    str = (String)o;
                }
                buf.append(str);
                for (c = str.length(); c < 32; ++c) {
                    buf.append(' ');
                }
                str = md.getTypeAsString(index);
                buf.append(str);
                for (c = str.length(); c < 10; ++c) {
                    buf.append(' ');
                }
                str = String.valueOf(md.boffset[index]);
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                str = String.valueOf(md.blength[index]);
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof RecordMetaData) {
                    str = String.valueOf(((RecordMetaData)((Object)md)).getByteOffset(index));
                    buf.append(str);
                    for (c = str.length(); c < 8; ++c) {
                        buf.append(' ');
                    }
                }
                str = String.valueOf(md.getByteLength(index));
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof RecordMetaData) {
                    str = String.valueOf(((RecordMetaData)((Object)md)).getUnicodeByteOffset(index));
                    buf.append(str);
                    for (c = str.length(); c < 8; ++c) {
                        buf.append(' ');
                    }
                }
                str = String.valueOf(md.getUnicodeByteLength(index));
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                buf.append(CRLF);
            }
        }
        return buf;
    }

    protected static StringBuilder dumpMetadata(Object obj, List<Object> dumpedMds) {
        if (obj == null) {
            return new StringBuilder();
        }
        try {
            ArrayList<Object> mdsToDump = new ArrayList<Object>();
            if (dumpedMds == null) {
                dumpedMds = new ArrayList<Object>();
            }
            mdsToDump.add(obj);
            StringBuilder buf = TraceUtils.dumpMetadata(mdsToDump, dumpedMds);
            return buf;
        }
        catch (Throwable t) {
            StringBuilder buf = new StringBuilder();
            buf.append("[").append(t.toString()).append(" within the trace]");
            return buf;
        }
    }

    protected static String dumpMetadata(Object obj) {
        return TraceUtils.dumpMetadata(obj, null).toString();
    }
}

