/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocDatatype;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.rt.ValueRange;
import com.sap.conn.idoc.rt.record.ExtendedFieldMetaData;
import com.sap.conn.idoc.rt.util.ObjectList;
import com.sap.conn.idoc.rt.util.SyncDateFormat;
import java.io.Serializable;
import java.text.ParseException;

public class DefaultIDocFieldMetaData
implements ExtendedFieldMetaData,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1000L;
    protected static final SyncDateFormat m_dateFormat = new SyncDateFormat("yyyyMMdd");
    protected static final SyncDateFormat m_timeFormat = new SyncDateFormat("HHmmss");
    protected String m_fieldName = null;
    protected int m_internalLength = 0;
    protected int m_outputLength = 0;
    protected String m_dataTypeName = null;
    protected String m_dataElementName = null;
    protected String m_domainName = null;
    protected String m_description = null;
    protected String m_checkTableName = null;
    protected boolean m_isISOCode = false;
    protected ObjectList m_valueRangeList = null;
    protected IDocDatatype m_datatype = null;

    protected DefaultIDocFieldMetaData(String fieldName, int internalLength, int outputLength, String dataTypeName, String dataElementName, String domainName, String description, String checkTableName, boolean isISOCode) {
        this.m_fieldName = fieldName;
        this.m_internalLength = internalLength;
        this.m_outputLength = outputLength;
        this.m_dataTypeName = dataTypeName;
        this.m_dataElementName = dataElementName;
        this.m_domainName = domainName;
        this.m_description = description;
        this.m_checkTableName = checkTableName;
        this.m_isISOCode = isISOCode;
        this.m_datatype = DefaultIDocFieldMetaData.parseDataDictionaryType(this.m_dataTypeName);
    }

    public void addValue(String value) {
        this.addValueRange(new ValueRange(value, null, null));
    }

    public void addValue(String value, String description) {
        this.addValueRange(new ValueRange(value, null, description));
    }

    public void addValueRange(String lowValue, String highValue) {
        this.addValueRange(new ValueRange(lowValue, highValue, null));
    }

    public void addValueRange(String lowValue, String highValue, String description) {
        this.addValueRange(new ValueRange(lowValue, highValue, description));
    }

    private final void addValueRange(ValueRange valueRange) {
        if (this.m_valueRangeList != null) {
            this.m_valueRangeList.add(valueRange);
        } else {
            this.m_valueRangeList = new ObjectList(valueRange);
        }
    }

    protected Object clone() {
        try {
            DefaultIDocFieldMetaData cloned = (DefaultIDocFieldMetaData)super.clone();
            if (this.m_valueRangeList != null) {
                cloned.m_valueRangeList = (ObjectList)this.m_valueRangeList.clone();
            }
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public static String createKey(String recordType, String fieldName) {
        StringBuilder key = new StringBuilder(61);
        key.append(recordType);
        key.append('|');
        key.append(fieldName);
        return key.toString();
    }

    public String getCheckTableName() {
        return this.m_checkTableName;
    }

    public IDocDatatype getDatatype() {
        return this.m_datatype;
    }

    public String getDataTypeName() {
        return this.m_dataTypeName;
    }

    public String getDataElementName() {
        return this.m_dataElementName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getDomainName() {
        return this.m_domainName;
    }

    public int getInternalLength() {
        return this.m_internalLength;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public int getOutputLength() {
        return this.m_outputLength;
    }

    public String getValueDescription(String value) {
        if (this.m_valueRangeList != null) {
            ValueRange valueRange = null;
            int numValueRanges = this.m_valueRangeList.size();
            for (int i = 0; i < numValueRanges; ++i) {
                valueRange = (ValueRange)this.m_valueRangeList.get(i);
                if (!valueRange.isInValueRange(value)) continue;
                return valueRange.getDescription();
            }
        }
        return null;
    }

    public String[] getValueDescriptions() {
        String[] descriptions = null;
        if (this.m_valueRangeList != null) {
            int numValueRanges = this.m_valueRangeList.size();
            descriptions = new String[numValueRanges];
            for (int i = 0; i < numValueRanges; ++i) {
                descriptions[i] = ((ValueRange)this.m_valueRangeList.get(i)).getDescription();
            }
        } else {
            descriptions = new String[]{};
        }
        return descriptions;
    }

    public String[][] getValueRanges() {
        String[][] valueRanges = null;
        if (this.m_valueRangeList != null) {
            ValueRange valueRange = null;
            int numValueRanges = this.m_valueRangeList.size();
            valueRanges = new String[numValueRanges][2];
            for (int i = 0; i < numValueRanges; ++i) {
                valueRange = (ValueRange)this.m_valueRangeList.get(i);
                valueRanges[i][0] = valueRange.getLowValue();
                valueRanges[i][1] = valueRange.getHighValue();
            }
        } else {
            valueRanges = new String[0][0];
        }
        return valueRanges;
    }

    public String[] getValues() {
        String[] values = null;
        if (this.m_valueRangeList != null) {
            ValueRange valueRange = null;
            int numValueRanges = this.m_valueRangeList.size();
            values = new String[numValueRanges];
            for (int i = 0; i < numValueRanges; ++i) {
                valueRange = (ValueRange)this.m_valueRangeList.get(i);
                values[i] = valueRange.getHighValue() == null ? valueRange.getLowValue() : valueRange.getLowValue() + " - " + valueRange.getHighValue();
            }
        } else {
            values = new String[]{};
        }
        return values;
    }

    public boolean isISOCode() {
        return this.m_isISOCode;
    }

    public boolean isValidValue(String value) {
        return this.isValidValue(value, true, null);
    }

    public boolean isValidValue(String value, boolean checkDatatype) {
        return this.isValidValue(value, checkDatatype, null);
    }

    private boolean isValidValue(String value, boolean checkDatatype, IDocRepository repository) {
        if (value != null && value.length() > 0 && value.charAt(0) == '/') {
            int i;
            int len = value.length();
            if (len == 1) {
                return true;
            }
            for (i = 1; i < len && value.charAt(i) == ' '; ++i) {
            }
            if (i == len) {
                return true;
            }
        }
        boolean valid = true;
        if (checkDatatype) {
            valid = this.isValueMatchingDatatype(value);
        }
        if (valid && this.m_valueRangeList != null) {
            valid = false;
            int numValueRanges = this.m_valueRangeList.size();
            for (int i = 0; i < numValueRanges; ++i) {
                if (!((ValueRange)this.m_valueRangeList.get(i)).isInValueRange(value)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValueMatchingDatatype(String value) {
        int i;
        if (this.m_datatype == IDocDatatype.STRING || this.m_datatype == IDocDatatype.BINARY) {
            return true;
        }
        if (value == null) {
            return true;
        }
        int len = value.length();
        if (len == 0) {
            return true;
        }
        if (value.charAt(0) == '/') {
            ++i;
            while (i < len && value.charAt(i) == ' ') {
                ++i;
            }
            if (i == len) {
                return true;
            }
            i = 0;
        } else {
            for (i = 0; i < len && value.charAt(i) == ' '; ++i) {
            }
            if (i == len) {
                return true;
            }
        }
        int c = 32;
        if (this.m_datatype == IDocDatatype.NUMERIC) {
            while (i < len) {
                if ((c = (int)value.charAt(i++)) < 48) {
                    if (c != 32) {
                        return false;
                    }
                    break;
                }
                if (c <= 57) continue;
                return false;
            }
        } else if (this.m_datatype == IDocDatatype.INTEGER) {
            boolean signParsed = false;
            if ((c = (int)value.charAt(i++)) < 48) {
                if (c != 45 && c != 43) return false;
                if (i == len) {
                    return false;
                }
                if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                    return false;
                }
                signParsed = true;
            } else if (c > 57) {
                return false;
            }
            while (i < len) {
                if ((c = (int)value.charAt(i++)) < 48) {
                    if (c != 32) {
                        if (c != 45 && c != 43) return false;
                        if (signParsed) {
                            return false;
                        }
                        if (i == len) {
                            return true;
                        }
                        if ((c = (int)value.charAt(i++)) != 32) {
                            return false;
                        }
                    }
                    break;
                }
                if (c <= 57) continue;
                return false;
            }
        } else if (this.m_datatype == IDocDatatype.DECIMAL) {
            boolean signParsed = false;
            boolean dotParsed = false;
            boolean expParsed = false;
            if ((c = (int)value.charAt(i++)) < 48) {
                if (c == 45 || c == 43) {
                    if (i == len) {
                        return false;
                    }
                    if ((c = (int)value.charAt(i++)) < 48) {
                        if (c != 46) {
                            return false;
                        }
                        if (i == len) {
                            return false;
                        }
                        if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                            return false;
                        }
                        dotParsed = true;
                    } else if (c > 57) {
                        return false;
                    }
                    signParsed = true;
                } else if (c == 46) {
                    if (i == len) {
                        return false;
                    }
                    if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                        return false;
                    }
                    dotParsed = true;
                }
            } else if (c > 57) {
                return false;
            }
            while (i < len) {
                if ((c = (int)value.charAt(i++)) < 48) {
                    if (c != 32) {
                        if (c == 46) {
                            if (dotParsed) {
                                return false;
                            }
                            dotParsed = true;
                            continue;
                        }
                        if (c != 45 && c != 43) return false;
                        if (signParsed) {
                            return false;
                        }
                        if (i == len) {
                            return true;
                        }
                        if ((c = (int)value.charAt(i++)) != 32) {
                            return false;
                        }
                    }
                    break;
                }
                if (c <= 57) continue;
                if (c != 69 && c != 101) return false;
                if (expParsed || i == len) {
                    return false;
                }
                if ((c = (int)value.charAt(i++)) < 48) {
                    if (c != 43 && c != 45 || i == len) {
                        return false;
                    }
                    if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                        return false;
                    }
                } else if (c > 57) {
                    return false;
                }
                dotParsed = true;
                expParsed = true;
            }
        } else if (this.m_datatype == IDocDatatype.DATE) {
            if (i + 8 > len) {
                return false;
            }
            String date = value.substring(i, i + 8);
            if (!date.equals("00000000") && !date.equals("99999999")) {
                try {
                    m_dateFormat.parse(date);
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            i += 8;
        } else {
            if (this.m_datatype != IDocDatatype.TIME) return true;
            if (i + 6 > len) {
                return false;
            }
            String time = value.substring(i, i + 6);
            if (!time.equals("240000")) {
                try {
                    m_timeFormat.parse(time);
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            i += 6;
        }
        while (i < len) {
            if (value.charAt(i++) == ' ') continue;
            return false;
        }
        return true;
    }

    protected static IDocDatatype parseDataDictionaryType(String type) {
        if (type != null) {
            if (type.length() == 4) {
                if (type.equals("CHAR")) {
                    return IDocDatatype.STRING;
                }
                if (type.equals("QUAN")) {
                    return IDocDatatype.DECIMAL;
                }
                if (type.equals("UNIT")) {
                    return IDocDatatype.STRING;
                }
                if (type.equals("NUMC")) {
                    return IDocDatatype.NUMERIC;
                }
                if (type.equals("DATS")) {
                    return IDocDatatype.DATE;
                }
                if (type.equals("TIMS")) {
                    return IDocDatatype.TIME;
                }
                if (type.equals("CURR")) {
                    return IDocDatatype.DECIMAL;
                }
                if (type.equals("CUKY")) {
                    return IDocDatatype.STRING;
                }
                if (type.equals("LANG")) {
                    return IDocDatatype.STRING;
                }
                if (type.equals("CLNT")) {
                    return IDocDatatype.STRING;
                }
                if (type.equals("INT1")) {
                    return IDocDatatype.INTEGER;
                }
                if (type.equals("INT2")) {
                    return IDocDatatype.INTEGER;
                }
                if (type.equals("INT4")) {
                    return IDocDatatype.INTEGER;
                }
                if (type.equals("FLTP")) {
                    return IDocDatatype.DECIMAL;
                }
                if (type.equals("ACCP")) {
                    return IDocDatatype.NUMERIC;
                }
                if (type.equals("PREC")) {
                    return IDocDatatype.NUMERIC;
                }
                if (type.equals("LRAW")) {
                    return IDocDatatype.BINARY;
                }
            } else if (type.length() == 3) {
                if (type.equals("DEC")) {
                    return IDocDatatype.DECIMAL;
                }
                if (type.equals("RAW")) {
                    return IDocDatatype.BINARY;
                }
            } else {
                if (type.equals("STRING")) {
                    return IDocDatatype.STRING;
                }
                if (type.equals("RAWSTRING")) {
                    return IDocDatatype.BINARY;
                }
            }
        }
        return IDocDatatype.STRING;
    }
}

