/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.MapToDictionary;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

class ServiceRegistrationImpl
implements ServiceRegistration {
    private final ServiceRegistry m_registry;
    private final Bundle m_bundle;
    private final String[] m_classes;
    private final Long m_serviceId;
    private volatile Object m_svcObj;
    private volatile ServiceFactory m_factory;
    private volatile Map m_propMap = new StringMap(false);
    private final ServiceReferenceImpl m_ref;
    private volatile boolean m_isUnregistering = false;

    public ServiceRegistrationImpl(ServiceRegistry registry, Bundle bundle, String[] classes, Long serviceId, Object svcObj, Dictionary dict) {
        this.m_registry = registry;
        this.m_bundle = bundle;
        this.m_classes = classes;
        this.m_serviceId = serviceId;
        this.m_svcObj = svcObj;
        this.m_factory = this.m_svcObj instanceof ServiceFactory ? (ServiceFactory)this.m_svcObj : null;
        this.initializeProperties(dict);
        this.m_ref = new ServiceReferenceImpl();
    }

    protected synchronized boolean isValid() {
        return this.m_svcObj != null;
    }

    protected synchronized void invalidate() {
        this.m_svcObj = null;
    }

    public synchronized ServiceReference getReference() {
        if (!this.isValid()) {
            throw new IllegalStateException("The service registration is no longer valid.");
        }
        return this.m_ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary dict) {
        Map oldProps;
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (!this.isValid()) {
                throw new IllegalStateException("The service registration is no longer valid.");
            }
            oldProps = this.m_propMap;
            this.initializeProperties(dict);
        }
        this.m_registry.servicePropertiesModified(this, new MapToDictionary(oldProps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (!this.isValid() || this.m_isUnregistering) {
                throw new IllegalStateException("Service already unregistered.");
            }
            this.m_isUnregistering = true;
        }
        this.m_registry.unregisterService(this.m_bundle, this);
        serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            this.m_svcObj = null;
            this.m_factory = null;
        }
    }

    private boolean isClassAccessible(Class clazz) {
        if (this.m_factory != null && this.m_factory.getClass().getClassLoader() instanceof BundleReference && !((BundleReference)((Object)this.m_factory.getClass().getClassLoader())).getBundle().equals(this.m_bundle)) {
            return true;
        }
        Class<?> sourceClass = this.m_factory != null ? this.m_factory.getClass() : this.m_svcObj.getClass();
        return Util.loadClassUsingClass(sourceClass, clazz.getName(), Felix.m_secureAction) == clazz;
    }

    Object getProperty(String key) {
        return this.m_propMap.get(key);
    }

    private String[] getPropertyKeys() {
        Set s = this.m_propMap.keySet();
        return s.toArray(new String[s.size()]);
    }

    private Bundle[] getUsingBundles() {
        return this.m_registry.getUsingBundles(this.m_ref);
    }

    Object getService() {
        return this.m_svcObj;
    }

    Object getService(Bundle acqBundle) {
        if (this.m_factory != null) {
            Object svcObj = null;
            try {
                svcObj = System.getSecurityManager() != null ? AccessController.doPrivileged(new ServiceFactoryPrivileged(acqBundle, null)) : this.getFactoryUnchecked(acqBundle);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof ServiceException) {
                    throw (ServiceException)ex.getException();
                }
                throw new ServiceException("Service factory exception: " + ex.getException().getMessage(), 3, ex.getException());
            }
            return svcObj;
        }
        return this.m_svcObj;
    }

    void ungetService(Bundle relBundle, Object svcObj) {
        if (this.m_factory != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new ServiceFactoryPrivileged(relBundle, svcObj));
                } else {
                    this.ungetFactoryUnchecked(relBundle, svcObj);
                }
            }
            catch (Exception ex) {
                this.m_registry.getLogger().log(this.m_bundle, 1, "ServiceRegistrationImpl: Error ungetting service.", (Throwable)ex);
            }
        }
    }

    private void initializeProperties(Dictionary dict) {
        StringMap props = new StringMap(false);
        if (dict != null) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (props.get(key) == null) {
                    props.put(key, dict.get(key));
                    continue;
                }
                throw new IllegalArgumentException("Duplicate service property: " + key);
            }
        }
        props.put("objectClass", this.m_classes);
        props.put("service.id", this.m_serviceId);
        this.m_propMap = props;
    }

    private Object getFactoryUnchecked(Bundle bundle) {
        Object svcObj = null;
        try {
            svcObj = this.m_factory.getService(bundle, this);
        }
        catch (Throwable th) {
            throw new ServiceException("Service factory exception: " + th.getMessage(), 3, th);
        }
        if (svcObj != null) {
            for (int i = 0; i < this.m_classes.length; ++i) {
                Class clazz = Util.loadClassUsingClass(svcObj.getClass(), this.m_classes[i], Felix.m_secureAction);
                if (clazz != null && clazz.isAssignableFrom(svcObj.getClass())) continue;
                if (clazz == null) {
                    throw new ServiceException("Service cannot be cast due to missing class: " + this.m_classes[i], 2);
                }
                throw new ServiceException("Service cannot be cast: " + this.m_classes[i], 2);
            }
        } else {
            throw new ServiceException("Service factory returned null.", 2);
        }
        return svcObj;
    }

    private void ungetFactoryUnchecked(Bundle bundle, Object svcObj) {
        this.m_factory.ungetService(bundle, this, svcObj);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServiceReferenceImpl
    implements ServiceReference,
    Capability {
        private ServiceReferenceImpl() {
        }

        ServiceRegistrationImpl getRegistration() {
            return ServiceRegistrationImpl.this;
        }

        @Override
        public Module getModule() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getNamespace() {
            return "service-reference";
        }

        @Override
        public Directive getDirective(String name) {
            return null;
        }

        @Override
        public List<Directive> getDirectives() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Attribute getAttribute(String name) {
            Object value = ServiceRegistrationImpl.this.getProperty(name);
            return value == null ? null : new Attribute(name, value, false);
        }

        @Override
        public List<Attribute> getAttributes() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<String> getUses() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Object getProperty(String s) {
            return ServiceRegistrationImpl.this.getProperty(s);
        }

        @Override
        public String[] getPropertyKeys() {
            return ServiceRegistrationImpl.this.getPropertyKeys();
        }

        @Override
        public Bundle getBundle() {
            return ServiceRegistrationImpl.this.isValid() ? ServiceRegistrationImpl.this.m_bundle : null;
        }

        @Override
        public Bundle[] getUsingBundles() {
            return ServiceRegistrationImpl.this.getUsingBundles();
        }

        public String toString() {
            String[] ocs = (String[])this.getProperty("objectClass");
            String oc = "[";
            for (int i = 0; i < ocs.length; ++i) {
                oc = new StringBuffer().append(oc).append(ocs[i]).toString();
                if (i >= ocs.length - 1) continue;
                oc = new StringBuffer().append(oc).append(", ").toString();
            }
            oc = new StringBuffer().append(oc).append("]").toString();
            return oc;
        }

        @Override
        public boolean isAssignableTo(Bundle requester, String className) {
            if (requester == ServiceRegistrationImpl.this.m_bundle) {
                return true;
            }
            boolean allow = true;
            String pkgName = Util.getClassPackage(className);
            Module requesterModule = ((BundleImpl)requester).getCurrentModule();
            Wire requesterWire = Util.getWire(requesterModule, pkgName);
            Module providerModule = ((BundleImpl)ServiceRegistrationImpl.this.m_bundle).getCurrentModule();
            Wire providerWire = Util.getWire(providerModule, pkgName);
            if (requesterWire == null && providerWire == null) {
                try {
                    Class requestClass = requesterModule.getClassByDelegation(className);
                    allow = this.getRegistration().isClassAccessible(requestClass);
                }
                catch (Exception ex) {
                    allow = true;
                }
            } else if (requesterWire == null && providerWire != null) {
                if (providerWire.getExporter().equals(requesterModule)) {
                    allow = true;
                } else {
                    try {
                        Class requestClass = requesterModule.getClassByDelegation(className);
                        try {
                            allow = providerWire.getClass(className) == requestClass;
                        }
                        catch (Exception ex) {
                            allow = false;
                        }
                    }
                    catch (Exception ex) {
                        allow = true;
                    }
                }
            } else if (requesterWire != null && providerWire == null) {
                if (((BundleImpl)ServiceRegistrationImpl.this.m_bundle).hasModule(requesterWire.getExporter())) {
                    allow = providerModule.equals(requesterWire.getExporter());
                } else {
                    try {
                        Class requestClass = requesterModule.getClassByDelegation(className);
                        allow = this.getRegistration().isClassAccessible(requestClass);
                    }
                    catch (Exception ex) {
                        allow = false;
                    }
                }
            } else {
                allow = providerWire.getExporter().equals(requesterWire.getExporter());
            }
            return allow;
        }

        @Override
        public int compareTo(Object reference) {
            Integer otherRank;
            Long otherId;
            ServiceReference other = (ServiceReference)reference;
            Long id = (Long)this.getProperty("service.id");
            if (id.equals(otherId = (Long)other.getProperty("service.id"))) {
                return 0;
            }
            Object rankObj = this.getProperty("service.ranking");
            Object otherRankObj = other.getProperty("service.ranking");
            rankObj = rankObj == null ? new Integer(0) : rankObj;
            otherRankObj = otherRankObj == null ? new Integer(0) : otherRankObj;
            Integer rank = rankObj instanceof Integer ? (Integer)rankObj : new Integer(0);
            Integer n = otherRank = otherRankObj instanceof Integer ? (Integer)otherRankObj : new Integer(0);
            if (rank.compareTo(otherRank) < 0) {
                return -1;
            }
            if (rank.compareTo(otherRank) > 0) {
                return 1;
            }
            return id.compareTo(otherId) < 0 ? 1 : -1;
        }
    }

    private class ServiceFactoryPrivileged
    implements PrivilegedExceptionAction {
        private Bundle m_bundle = null;
        private Object m_svcObj = null;

        public ServiceFactoryPrivileged(Bundle bundle, Object svcObj) {
            this.m_bundle = bundle;
            this.m_svcObj = svcObj;
        }

        public Object run() throws Exception {
            if (this.m_svcObj == null) {
                return ServiceRegistrationImpl.this.getFactoryUnchecked(this.m_bundle);
            }
            ServiceRegistrationImpl.this.ungetFactoryUnchecked(this.m_bundle, this.m_svcObj);
            return null;
        }
    }
}

