/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.cp;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;

public class Codepage {
    private static Hashtable<String, CPMap> cptable = new Hashtable(101);

    private Codepage() {
    }

    public static String getEncoding(String key) {
        CPMap c = Codepage.getCPMap(key);
        if (c == null) {
            return null;
        }
        String cp = c.encoding;
        try {
            byte[] b = new byte[]{90};
            new String(b, cp);
        }
        catch (UnsupportedEncodingException e) {
            cp = cp.toLowerCase(Locale.ENGLISH);
        }
        return cp;
    }

    public static String getMimeCharset(String key) {
        CPMap c = Codepage.getCPMap(key);
        if (c == null) {
            return null;
        }
        return c.mimeCharset;
    }

    public static boolean is2Byte(String key) {
        CPMap c = Codepage.getCPMap(key);
        if (c == null) {
            return false;
        }
        return c.is2byte;
    }

    public static String getCodepage(String key) {
        CPMap c = Codepage.getCPMap(key);
        if (c == null) {
            return null;
        }
        return c.codepage;
    }

    public static CPMap getCPMap(String key) {
        return key == null ? null : cptable.get(key.toLowerCase(Locale.ENGLISH));
    }

    static {
        CPMap aCPMap = new CPMap("0100", "Cp273", "IBM273", "EBCDIC 0697/0273", false);
        cptable.put("0100", aCPMap);
        cptable.put("cp273", aCPMap);
        cptable.put("ibm273", aCPMap);
        aCPMap = new CPMap("0120", "Cp500", "IBM500", "EBCDIC 0697/0500", false);
        cptable.put("0120", aCPMap);
        cptable.put("cp500", aCPMap);
        cptable.put("ibm500", aCPMap);
        aCPMap = new CPMap("0410", "Cp1025", "IBM1025", "EBCDIC 0959/0870", false);
        cptable.put("0410", aCPMap);
        cptable.put("cp1025", aCPMap);
        cptable.put("ibm1025", aCPMap);
        aCPMap = new CPMap("0500", "Cp855", "IBM855", "EBCDIC 1150/1025", false);
        cptable.put("0500", aCPMap);
        cptable.put("cp855", aCPMap);
        cptable.put("ibm855", aCPMap);
        aCPMap = new CPMap("0610", "Cp1026", "IBM1026", "EBCDIC 1152/1026", false);
        cptable.put("0610", aCPMap);
        cptable.put("cp1026", aCPMap);
        cptable.put("ibm1026", aCPMap);
        aCPMap = new CPMap("0700", "Cp875", "IBM875", "EBCDIC 0925/0875 (Greek)", false);
        cptable.put("0700", aCPMap);
        cptable.put("cp875", aCPMap);
        cptable.put("ibm875", aCPMap);
        aCPMap = new CPMap("0800", "Cp424", "IBM424", "EBCDIC 0941/0424", false);
        cptable.put("0800", aCPMap);
        cptable.put("cp424", aCPMap);
        cptable.put("ibm424", aCPMap);
        aCPMap = new CPMap("0860", "Cp874", "IBM874", "EBCDIC Thai", false);
        cptable.put("0860", aCPMap);
        cptable.put("cp874", aCPMap);
        cptable.put("ibm874", aCPMap);
        aCPMap = new CPMap("1100", "ISO8859_1", "iso-8859-1", "Latin 1", false);
        cptable.put("1100", aCPMap);
        cptable.put("1150", aCPMap);
        cptable.put("iso8859_1", aCPMap);
        cptable.put("iso-8859-1", aCPMap);
        cptable.put("de", aCPMap);
        cptable.put("en", aCPMap);
        cptable.put("fr", aCPMap);
        cptable.put("es", aCPMap);
        cptable.put("pt", aCPMap);
        cptable.put("it", aCPMap);
        cptable.put("da", aCPMap);
        cptable.put("nl", aCPMap);
        cptable.put("is", aCPMap);
        aCPMap = new CPMap("1180", "ISO8859_1", "iso-8859-1", "Latin 1 mixed with Latin2", false);
        cptable.put("1180", aCPMap);
        cptable.put("iso8859_1_tl2", aCPMap);
        cptable.put("iso-8859-1-tl2", aCPMap);
        aCPMap = new CPMap("1401", "ISO8859_2", "iso-8859-2", "Latin 2", false);
        cptable.put("1401", aCPMap);
        cptable.put("iso8859_2", aCPMap);
        cptable.put("iso-8859-2", aCPMap);
        cptable.put("pl", aCPMap);
        cptable.put("cs", aCPMap);
        cptable.put("sk", aCPMap);
        cptable.put("hr", aCPMap);
        cptable.put("hu", aCPMap);
        cptable.put("ro", aCPMap);
        cptable.put("sk", aCPMap);
        cptable.put("sh", aCPMap);
        cptable.put("sl", aCPMap);
        aCPMap = new CPMap("1500", "ISO8859_5", "iso-8859-5", "Cyrillic", false);
        cptable.put("1500", aCPMap);
        cptable.put("iso8859_5", aCPMap);
        cptable.put("iso-8859-5", aCPMap);
        cptable.put("sr", aCPMap);
        cptable.put("bg", aCPMap);
        cptable.put("ru", aCPMap);
        aCPMap = new CPMap("1600", "ISO8859_3", "iso-8859-3", "Latin 3", false);
        cptable.put("1600", aCPMap);
        cptable.put("iso8859_3", aCPMap);
        cptable.put("iso-8859-3", aCPMap);
        aCPMap = new CPMap("1610", "ISO8859_9", "iso-8859-9", "Latin 5/Turkish", false);
        cptable.put("1610", aCPMap);
        cptable.put("iso8859_9", aCPMap);
        cptable.put("iso-8859-9", aCPMap);
        cptable.put("tr", aCPMap);
        aCPMap = new CPMap("1700", "ISO8859_7", "iso-8859-7", "Greek", false);
        cptable.put("1700", aCPMap);
        cptable.put("iso8859_7", aCPMap);
        cptable.put("iso-8859-7", aCPMap);
        cptable.put("el", aCPMap);
        aCPMap = new CPMap("1800", "ISO8859_8", "iso-8859-8", "Hebrew", false);
        cptable.put("1800", aCPMap);
        aCPMap = new CPMap("1810", "ISO8859_8", "iso-8859-8", "Hebrew extended", false);
        cptable.put("1810", aCPMap);
        cptable.put("iso8859_8", aCPMap);
        cptable.put("iso-8859-8", aCPMap);
        cptable.put("he", aCPMap);
        aCPMap = new CPMap("1900", "ISO8859_4", "iso-8859-4", "Lithuanian/Latvian/Estonian", false);
        cptable.put("1900", aCPMap);
        cptable.put("iso8859_4", aCPMap);
        cptable.put("iso-8859-4", aCPMap);
        cptable.put("lt", aCPMap);
        cptable.put("lv", aCPMap);
        cptable.put("et", aCPMap);
        aCPMap = new CPMap("8000", "SJIS", "Shift_JIS", "Kanji, Japanese", true);
        cptable.put("8000", aCPMap);
        cptable.put("sjis", aCPMap);
        cptable.put("shift-jis", aCPMap);
        cptable.put("shift_jis", aCPMap);
        cptable.put("ja", aCPMap);
        aCPMap = new CPMap("8300", "Big5", "Big5", "Traditional Chinese", true);
        cptable.put("8300", aCPMap);
        cptable.put("big5", aCPMap);
        aCPMap = new CPMap("8340", "Big5_HKSCS", "Big5-HKSCS", "Hongkong Chinese", true);
        cptable.put("8340", aCPMap);
        cptable.put("big5_hkscs", aCPMap);
        cptable.put("big5-hkscs", aCPMap);
        cptable.put("zf", aCPMap);
        aCPMap = new CPMap("8341", "Big5_HKSCS", "Big5-HKSCS", "Hongkong Chinese", true);
        cptable.put("8341", aCPMap);
        cptable.put("big5_hkscs_v2", aCPMap);
        cptable.put("big5-hkscs-v2", aCPMap);
        aCPMap = new CPMap("8400", "EUC_CN", "GB2312", "English Chinese", true);
        cptable.put("8400", aCPMap);
        cptable.put("euc_cn", aCPMap);
        cptable.put("gb_2312-80", aCPMap);
        cptable.put("gb2312_80", aCPMap);
        cptable.put("gb2312-80", aCPMap);
        cptable.put("gb2312", aCPMap);
        cptable.put("zh", aCPMap);
        aCPMap = new CPMap("8450", "EUC_CN", "GB2312", "Special English Chinese", true);
        cptable.put("8450", aCPMap);
        aCPMap = new CPMap("8500", "EUC_KR", "KSC_5601", "Korean", true);
        cptable.put("8500", aCPMap);
        cptable.put("euc_kr", aCPMap);
        cptable.put("ksc5601", aCPMap);
        cptable.put("ksc_5601", aCPMap);
        cptable.put("ko", aCPMap);
        aCPMap = new CPMap("8600", "TIS620", "TIS-620", "Thai", false);
        cptable.put("8600", aCPMap);
        cptable.put("tis620", aCPMap);
        cptable.put("tis-620", aCPMap);
        cptable.put("th", aCPMap);
        aCPMap = new CPMap("8700", "ISO8859_6", "iso-8859-6", "Arabic", false);
        cptable.put("8700", aCPMap);
        cptable.put("iso8859_6", aCPMap);
        cptable.put("iso-8859-6", aCPMap);
        cptable.put("ar", aCPMap);
        aCPMap = new CPMap("6230", "SAP6230", "SAP-6230", "SAP Asian Unification (trad. Chinese + SJIS1)", true);
        cptable.put("6230", aCPMap);
        cptable.put("sap6230", aCPMap);
        cptable.put("sap-6230", aCPMap);
        aCPMap = new CPMap("6240", "SAP6240", "SAP-6240", "SAP Asian Unification (simp. Chinese + SJIS1)", true);
        cptable.put("6240", aCPMap);
        cptable.put("sap6240", aCPMap);
        cptable.put("sap-6240", aCPMap);
        aCPMap = new CPMap("6250", "SAP6250", "SAP-6250", "SAP Asian Unification (Korean + SJIS1)", true);
        cptable.put("6250", aCPMap);
        cptable.put("sap6250", aCPMap);
        cptable.put("sap-6250", aCPMap);
        aCPMap = new CPMap("6300", "SAP6300", "SAP-6300", "SAP Euro Japan (ISO1 + SJIS1)", true);
        cptable.put("6300", aCPMap);
        cptable.put("sap6300", aCPMap);
        cptable.put("sap-6300", aCPMap);
        aCPMap = new CPMap("6400", "SAP6400", "SAP-6400", "SAP Silk Road (ISO7 + SJIS1)", true);
        cptable.put("6400", aCPMap);
        cptable.put("sap6400", aCPMap);
        cptable.put("sap-6400", aCPMap);
        aCPMap = new CPMap("6600", "SAP6600", "SAP-6600", "SAP Nagamasa (Thai + SJIS1)", true);
        cptable.put("6600", aCPMap);
        cptable.put("sap6600", aCPMap);
        cptable.put("sap-6600", aCPMap);
        aCPMap = new CPMap("6100", "SAP6100", "SAP-6100", "SAP Eastern and Western Europe (ISO1 + ISO2)", false);
        cptable.put("6100", aCPMap);
        cptable.put("sap6100", aCPMap);
        cptable.put("sap-6100", aCPMap);
        aCPMap = new CPMap("6200", "SAP6200", "SAP-6200", "SAP Asian Unification (ASCII + SJIS1 + Asian)", false);
        cptable.put("6200", aCPMap);
        cptable.put("sap6200", aCPMap);
        cptable.put("sap-6200", aCPMap);
        aCPMap = new CPMap("6500", "SAP6500", "SAP-6500", "SAP Diocletian (ISO1 with ISO7 D7 and F7)", false);
        cptable.put("6500", aCPMap);
        cptable.put("sap6500", aCPMap);
        cptable.put("sap-6500", aCPMap);
        aCPMap = new CPMap("4110", "UTF8", "utf-8", "UTF8", true);
        cptable.put("4110", aCPMap);
        cptable.put("utf8", aCPMap);
        cptable.put("utf-8", aCPMap);
        aCPMap = new CPMap("4102", "UTF16", "utf-16", "UTF16", true);
        cptable.put("4102", aCPMap);
        cptable.put("utf16", aCPMap);
        cptable.put("utf-16", aCPMap);
        cptable.put("unicode", aCPMap);
        aCPMap = new CPMap("4103", "UTF16", "utf-16", "UTF16", true);
        cptable.put("4103", aCPMap);
    }

    public static class CPMap {
        public String codepage;
        public String encoding;
        public String mimeCharset;
        public String desc;
        public boolean is2byte;

        CPMap(String codepage, String encoding, String mimeCharset, String desc, boolean is2byte) {
            this.codepage = codepage;
            this.encoding = encoding;
            this.mimeCharset = mimeCharset;
            this.desc = desc;
            this.is2byte = is2byte;
        }
    }
}

