/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.util.SyncDateFormat;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.engine.RfcTraceWriter;
import com.sap.conn.rfc.engine.Trc;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;

class DefaultRfcTraceWriter
implements RfcTraceWriter {
    private static final String errorFilePrefix = "dev_jco_rfc";
    private static final String errorFileSuffix = ".trc";
    private static final String m_errorFileName = "dev_jco_rfc.trc";
    private static FileWriter m_errorTraceFile;
    private static final SyncDateFormat fileNameTimestampFormat;
    private static final long MAX_ERROR_FILE_LENGTH;
    private static final long MAX_TRACE_FILE_LENGTH = Long.MAX_VALUE;
    private static File m_errorFile;
    private static short maxErrorTraceBackups;
    private static ThreadLocal<TraceWriterFactory> locTraceFileFactory;

    DefaultRfcTraceWriter() {
    }

    @Override
    public void criticalTrace(String text) {
        DefaultRfcTraceWriter.openErrorTrace();
        if (m_errorTraceFile != null) {
            this.writeInErrorTrace(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openErrorTrace() {
        Class<DefaultRfcTraceWriter> clazz = DefaultRfcTraceWriter.class;
        synchronized (DefaultRfcTraceWriter.class) {
            if (m_errorTraceFile == null) {
                try {
                    Date date = new Date();
                    String path = null;
                    try {
                        path = JCo.getProperty("jco.trace_path");
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    if (path == null) {
                        path = System.getProperty("jco.trace_path");
                    }
                    StringBuffer fileName = new StringBuffer(256);
                    if (path != null) {
                        fileName.append(path);
                        fileName.append(System.getProperty("file.separator"));
                    }
                    fileName.append(m_errorFileName);
                    m_errorFile = new File(fileName.toString());
                    m_errorTraceFile = new FileWriter(m_errorFile, true);
                    m_errorTraceFile.write("\n**** Error file opened at " + openFileSyncDateFormat.format(date) + " Rel " + JCoRuntimeFactory.getRuntime().getVersion() + " [" + RfcApi.RfcGetVersion() + "]\n");
                    m_errorTraceFile.flush();
                }
                catch (Exception ex) {
                    m_errorFile = null;
                    m_errorTraceFile = null;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInErrorTrace(String text) {
        if (text == null) {
            return;
        }
        Class<DefaultRfcTraceWriter> clazz = DefaultRfcTraceWriter.class;
        synchronized (DefaultRfcTraceWriter.class) {
            long length = m_errorFile.length();
            if (length > MAX_ERROR_FILE_LENGTH) {
                Date now = new Date();
                boolean isClosed = false;
                try {
                    if (m_errorTraceFile != null) {
                        m_errorTraceFile.flush();
                        m_errorTraceFile.close();
                        m_errorTraceFile = null;
                        isClosed = true;
                    }
                }
                catch (IOException e) {
                    isClosed = false;
                }
                if (isClosed) {
                    String fullName = m_errorFile.getAbsolutePath();
                    String name = fullName.substring(0, fullName.lastIndexOf("."));
                    String timestamp = fileNameTimestampFormat.format(now);
                    if (m_errorFile.renameTo(new File(name + "." + timestamp + errorFileSuffix))) {
                        try {
                            m_errorFile.delete();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        m_errorFile = null;
                    }
                    DefaultRfcTraceWriter.openErrorTrace();
                }
                if (maxErrorTraceBackups >= 0) {
                    try {
                        File directory = m_errorFile.getCanonicalFile().getParentFile();
                        ErrorTraceBackupFilter backupFilter = new ErrorTraceBackupFilter();
                        File[] errorTraceBackups = directory.listFiles(backupFilter);
                        int toDelete = errorTraceBackups.length - maxErrorTraceBackups;
                        while (toDelete > 0) {
                            File oldest = errorTraceBackups[0];
                            int pos = 0;
                            for (int i = 1; i < errorTraceBackups.length; ++i) {
                                if (errorTraceBackups[i].lastModified() >= oldest.lastModified()) continue;
                                oldest = errorTraceBackups[i];
                                pos = i;
                            }
                            oldest.delete();
                            if (--toDelete <= 0) continue;
                            File[] newList = new File[errorTraceBackups.length - 1];
                            System.arraycopy(errorTraceBackups, 0, newList, 0, pos);
                            System.arraycopy(errorTraceBackups, pos + 1, newList, pos, newList.length - pos);
                            errorTraceBackups = newList;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                if (m_errorTraceFile != null) {
                    m_errorTraceFile.write(text);
                    m_errorTraceFile.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void closeTrace() {
        locTraceFileFactory.get().closeTrace();
    }

    @Override
    public void debugTrace(String text) {
        locTraceFileFactory.get().write(text);
    }

    @Override
    public void infoTrace(String text) {
        locTraceFileFactory.get().write(text);
    }

    @Override
    public void infoLog(String text) {
        locTraceFileFactory.get().write(text);
    }

    static {
        int tmpMaxErrorFileLength;
        fileNameTimestampFormat = new SyncDateFormat("yyyyMMdd_HHmmss");
        m_errorFile = null;
        maxErrorTraceBackups = (short)-1;
        try {
            tmpMaxErrorFileLength = Integer.parseInt(System.getProperty("jrfc.logfile.maxsize", "8")) * 1024 * 1024;
        }
        catch (Exception e) {
            tmpMaxErrorFileLength = 0x800000;
        }
        MAX_ERROR_FILE_LENGTH = tmpMaxErrorFileLength;
        try {
            maxErrorTraceBackups = Short.parseShort(System.getProperty("jrfc.logfile.maxbackups", "-1"));
        }
        catch (Exception e) {
            maxErrorTraceBackups = (short)-1;
        }
        locTraceFileFactory = new ThreadLocal<TraceWriterFactory>(){

            @Override
            protected TraceWriterFactory initialValue() {
                return new TraceWriterFactory();
            }
        };
    }

    private static class TraceWriterFactory {
        private File currentFile = null;
        private FileWriter currentFileWriter = null;
        private String baseName = null;
        private int fileCounter = 0;
        private String version;

        TraceWriterFactory() {
            StringBuilder fName = new StringBuilder(256);
            String path = JCo.getProperty("jco.trace_path");
            if (path == null) {
                path = System.getProperty("jco.trace_path");
            }
            if (path != null && new File(path).isDirectory()) {
                fName.append(path);
                fName.append(System.getProperty("file.separator"));
            }
            String jrfcTraceFileName = CpicDriver.getTraceFileName();
            fName.append("jco_");
            fName.append(jrfcTraceFileName.substring(1, jrfcTraceFileName.length() - 4));
            this.baseName = fName.toString();
            this.version = " Rel. " + JCoRuntimeFactory.getRuntime().getVersion() + " [" + RfcApi.RfcGetVersion() + "]\n";
        }

        private String getNextFileName() {
            ++this.fileCounter;
            StringBuilder fName = new StringBuilder(256);
            fName.append(this.baseName).append('.');
            if (this.fileCounter < 100) {
                fName.append('0');
            }
            if (this.fileCounter < 10) {
                fName.append('0');
            }
            fName.append(this.fileCounter);
            fName.append(DefaultRfcTraceWriter.errorFileSuffix);
            return fName.toString();
        }

        private String createMarker() {
            StringBuilder sb = new StringBuilder("\n**** Trace file opened at ").append(RfcTraceWriter.openFileSyncDateFormat.format(new Date())).append(this.version);
            return sb.toString();
        }

        private FileWriter getWriter() {
            boolean createNextFile = this.currentFile == null || this.currentFile.length() > Long.MAX_VALUE;
            try {
                if (createNextFile) {
                    this.currentFile = new File(this.getNextFileName());
                    if (this.currentFile.exists()) {
                        this.currentFile.delete();
                    }
                    this.currentFileWriter = new FileWriter(this.currentFile);
                    this.currentFileWriter.write("\n**** Trace file opened at " + RfcTraceWriter.openFileSyncDateFormat.format(new Date()) + " Rel. " + JCoRuntimeFactory.getRuntime().getVersion() + " [" + RfcApi.RfcGetVersion() + "]\n");
                    this.currentFileWriter.flush();
                } else if (this.currentFileWriter == null) {
                    this.currentFileWriter = new FileWriter(this.currentFile, true);
                    this.currentFileWriter.write(this.createMarker());
                }
                return this.currentFileWriter;
            }
            catch (Exception ex) {
                StringBuffer msg = new StringBuffer(256);
                msg.append("JRFC Error> Could not create regular trace file\n");
                msg.append("    exception occured: ");
                msg.append(ex.getMessage());
                Trc.criticalTrace(0L, msg.toString());
                return null;
            }
        }

        public void closeTrace() {
            try {
                if (this.currentFileWriter != null) {
                    this.currentFileWriter.close();
                    this.currentFileWriter = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void write(String text) {
            FileWriter writer = this.getWriter();
            if (writer == null) {
                return;
            }
            try {
                writer.write(text);
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class ErrorTraceBackupFilter
    implements FilenameFilter {
        ErrorTraceBackupFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.length() == DefaultRfcTraceWriter.m_errorFileName.length() + 16 && name.endsWith(DefaultRfcTraceWriter.errorFileSuffix) && name.startsWith(DefaultRfcTraceWriter.errorFilePrefix) && name.charAt(DefaultRfcTraceWriter.errorFilePrefix.length()) == '.' && name.charAt(DefaultRfcTraceWriter.errorFilePrefix.length() + 9) == '_') {
                int i;
                int end = DefaultRfcTraceWriter.errorFilePrefix.length() + 9;
                for (i = DefaultRfcTraceWriter.errorFilePrefix.length() + 1; i < end; ++i) {
                    if (Character.isDigit(name.charAt(i))) continue;
                    return false;
                }
                end = DefaultRfcTraceWriter.errorFilePrefix.length() + 16;
                for (i = DefaultRfcTraceWriter.errorFilePrefix.length() + 10; i < end; ++i) {
                    if (Character.isDigit(name.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

