/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.tools.lv.LVFormatOption;
import com.sap.tc.logging.tools.lv.LVFormatPattern;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

class LVFormatter
extends Formatter {
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy");
    private static final String SPACE = " ";
    private LVFormatPattern formatPattern;

    public LVFormatter(String pattern) {
        this.formatPattern = new LVFormatPattern(pattern);
    }

    public String format(LogRecord record) {
        StringBuffer outBuf = new StringBuffer();
        Iterator iter = LVFormatPattern.parsedOptions.iterator();
        Date date = record.getTime();
        block9: while (iter.hasNext()) {
            LVFormatOption formatOption = (LVFormatOption)iter.next();
            String tmpVal = "";
            switch (formatOption.type) {
                case 1: {
                    if (!formatOption.isEnabled) continue block9;
                    tmpVal = dateFormatter.format(date);
                    break;
                }
                case 2: {
                    if (!formatOption.isEnabled) continue block9;
                    tmpVal = timeFormatter.format(date);
                    break;
                }
                case 3: {
                    if (!formatOption.isEnabled) continue block9;
                    tmpVal = Severity.toString(record.getSeverity()).toUpperCase(Locale.ENGLISH);
                    break;
                }
                case 4: {
                    if (!formatOption.isEnabled) continue block9;
                    tmpVal = record.getId().toString();
                    break;
                }
                case 5: {
                    if (!formatOption.isEnabled) continue block9;
                    tmpVal = record.getLocationName();
                    break;
                }
                case 6: {
                    if (!formatOption.isEnabled) continue block9;
                    tmpVal = LVFormatter.getCategory(record);
                    break;
                }
                case 7: {
                    if (!formatOption.isEnabled) continue block9;
                    tmpVal = this.getMessage(record);
                }
            }
            if (tmpVal == null || tmpVal.length() <= 0) continue;
            outBuf.append(SPACE + LVFormatter.printString(tmpVal, formatOption.width, formatOption.align));
        }
        return outBuf.toString();
    }

    protected static String printString(String value, int width, int align) {
        if (value == null) {
            return "";
        }
        StringBuffer tmpBuffer = new StringBuffer();
        int pad = 0;
        if (width == -1) {
            align = 1;
        } else if (width < value.length()) {
            value = value.substring(0, width);
        } else {
            pad = width - value.length();
        }
        for (int i = 0; i < pad; ++i) {
            tmpBuffer.append(SPACE);
        }
        switch (align) {
            case 1: {
                tmpBuffer.insert(0, value);
                break;
            }
            case 2: {
                if (pad > 0) {
                    tmpBuffer.insert(pad / 2, value);
                    break;
                }
                tmpBuffer.append(value);
                break;
            }
            case 3: {
                tmpBuffer.append(value);
            }
        }
        return tmpBuffer.toString();
    }

    protected static String getCategory(LogRecord logRec) {
        if (logRec.getLocationName().equalsIgnoreCase(logRec.getSourceName())) {
            return logRec.getRelatives().toString();
        }
        return logRec.getSourceName();
    }

    private String getMessage(LogRecord record) {
        Object msg = null;
        String msgClear = record.getMsgClear();
        List<String> args = record.getArgs();
        if (!args.isEmpty()) {
            return this.formatMessage(msgClear, args.toArray());
        }
        return msgClear;
    }

    private String formatMessage(String msgClear, Object[] args) {
        String result;
        try {
            result = MessageFormat.format(msgClear, args);
        }
        catch (IllegalArgumentException ex) {
            result = "msg [" + msgClear + "]  params [" + args + "]";
        }
        return result;
    }
}

