/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.sysfunc;

import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.data.RfcChar;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcException;

public final class RfcSetRegServerProperty
implements IRfcFunction {
    private static final String name = "RFC_SET_REG_SERVER_PROPERTY";
    private static final String[] documentation = new String[]{"Set different properties for a registered server", "", "IMPORTING", "  EXCLUSIV(1): 'Y': Start exclusive use of this registered server", "               'N': Stop  exclusive use of this registered server", "               'E': Disconnect"};

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void execute(RfcIoOpenCntl act_cntl) throws RfcException {
        IRfcParameter[] imp = new IRfcParameter[1];
        RfcChar exclusiv = new RfcChar(act_cntl, "EXCLUSIV");
        exclusiv.setValue('N');
        imp[0] = exclusiv;
        act_cntl.RfcGetData(imp, null, null, null, null);
        switch (exclusiv.getChar()) {
            case 'Y': {
                act_cntl.reg_exclusiv = true;
                break;
            }
            case 'N': {
                act_cntl.reg_exclusiv = false;
                break;
            }
            case 'E': {
                act_cntl.close_pending = true;
                act_cntl.reg_exclusiv = false;
                break;
            }
        }
        act_cntl.RfcSendData(null, null, null);
        act_cntl.flushServerConnection();
    }

    @Override
    public String[] getDocumentation() {
        return documentation;
    }
}

