/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009-11, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.riftsaw.engine;

import org.w3c.dom.Element;

/**
 * This interface represents an external service that can be invoked
 * by a BPEL process.
 *
 */
public interface Service {

    /**
     * This method invokes an operation on an external service.
     * The header map is supplied to provide header values for the
     * request, and also to receive header values from a response.
     * 
     * @param operationName The operation name
     * @param mesg The multipart message
     * @param headers The header values
     * @return The response, or null if a one-way request
     * @throws Exception Failed to invoke operation
     */
    public Element invoke(String operationName, Element mesg,
                        java.util.Map<String, Object> headers) throws Exception;
    
}
