/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsWrapperTypeSerializer
extends TypeSerializerBase {
    public AsWrapperTypeSerializer(TypeIdResolver idRes, BeanProperty property) {
        super(idRes, property);
    }

    @Override
    public AsWrapperTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsWrapperTypeSerializer(this._idResolver, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator g) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartObject();
        } else {
            g.writeStartObject();
            g.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator g, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartObject();
        } else {
            g.writeStartObject();
            g.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator g) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartArray();
        } else {
            g.writeStartObject();
            g.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator g, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartArray();
        } else {
            g.writeStartObject();
            g.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
        } else {
            g.writeStartObject();
            g.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
        } else {
            g.writeStartObject();
            g.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object value2, JsonGenerator g) throws IOException {
        g.writeEndObject();
        if (!g.canWriteTypeId()) {
            g.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForArray(Object value2, JsonGenerator g) throws IOException {
        g.writeEndArray();
        if (!g.canWriteTypeId()) {
            g.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForScalar(Object value2, JsonGenerator g) throws IOException {
        if (!g.canWriteTypeId()) {
            g.writeEndObject();
        }
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value2, JsonGenerator g, String typeId) throws IOException {
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartObject();
        } else {
            g.writeStartObject();
            g.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypePrefixForArray(Object value2, JsonGenerator g, String typeId) throws IOException {
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartArray();
        } else {
            g.writeStartObject();
            g.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object value2, JsonGenerator g, String typeId) throws IOException {
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
        } else {
            g.writeStartObject();
            g.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value2, JsonGenerator g, String typeId) throws IOException {
        if (!g.canWriteTypeId()) {
            this.writeTypeSuffixForObject(value2, g);
        }
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object value2, JsonGenerator g, String typeId) throws IOException {
        if (!g.canWriteTypeId()) {
            this.writeTypeSuffixForArray(value2, g);
        }
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object value2, JsonGenerator g, String typeId) throws IOException {
        if (!g.canWriteTypeId()) {
            this.writeTypeSuffixForScalar(value2, g);
        }
    }

    protected String _validTypeId(String typeId) {
        return typeId == null ? "" : typeId;
    }
}

