/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public abstract class JSR310DateTimeDeserializerBase<T>
extends JSR310DeserializerBase<T>
implements ContextualDeserializer {
    protected final DateTimeFormatter _formatter;

    protected JSR310DateTimeDeserializerBase(Class<T> supportedType, DateTimeFormatter f2) {
        super(supportedType);
        this._formatter = f2;
    }

    protected abstract JsonDeserializer<T> withDateFormat(DateTimeFormatter var1);

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format2;
        if (property != null && (format2 = ctxt.getAnnotationIntrospector().findFormat(property.getMember())) != null && format2.hasPattern()) {
            String pattern2 = format2.getPattern();
            Locale locale = format2.hasLocale() ? format2.getLocale() : ctxt.getLocale();
            DateTimeFormatter df = locale == null ? DateTimeFormatter.ofPattern(pattern2) : DateTimeFormatter.ofPattern(pattern2, locale);
            return this.withDateFormat(df);
        }
        return this;
    }
}

