/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.AbstractClientConnAdapter;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractPooledConnAdapter
extends AbstractClientConnAdapter {
    protected volatile AbstractPoolEntry poolEntry;

    protected AbstractPooledConnAdapter(ClientConnectionManager manager, AbstractPoolEntry entry2) {
        super(manager, entry2.connection);
        this.poolEntry = entry2;
    }

    protected AbstractPoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    protected void assertValid(AbstractPoolEntry entry2) {
        if (this.isReleased() || entry2 == null) {
            throw new ConnectionShutdownException();
        }
    }

    @Deprecated
    protected final void assertAttached() {
        if (this.poolEntry == null) {
            throw new ConnectionShutdownException();
        }
    }

    protected synchronized void detach() {
        this.poolEntry = null;
        super.detach();
    }

    public HttpRoute getRoute() {
        AbstractPoolEntry entry2 = this.getPoolEntry();
        this.assertValid(entry2);
        return entry2.tracker == null ? null : entry2.tracker.toRoute();
    }

    public void open(HttpRoute route, HttpContext context, HttpParams params2) throws IOException {
        AbstractPoolEntry entry2 = this.getPoolEntry();
        this.assertValid(entry2);
        entry2.open(route, context, params2);
    }

    public void tunnelTarget(boolean secure, HttpParams params2) throws IOException {
        AbstractPoolEntry entry2 = this.getPoolEntry();
        this.assertValid(entry2);
        entry2.tunnelTarget(secure, params2);
    }

    public void tunnelProxy(HttpHost next2, boolean secure, HttpParams params2) throws IOException {
        AbstractPoolEntry entry2 = this.getPoolEntry();
        this.assertValid(entry2);
        entry2.tunnelProxy(next2, secure, params2);
    }

    public void layerProtocol(HttpContext context, HttpParams params2) throws IOException {
        AbstractPoolEntry entry2 = this.getPoolEntry();
        this.assertValid(entry2);
        entry2.layerProtocol(context, params2);
    }

    public void close() throws IOException {
        OperatedClientConnection conn;
        AbstractPoolEntry entry2 = this.getPoolEntry();
        if (entry2 != null) {
            entry2.shutdownEntry();
        }
        if ((conn = this.getWrappedConnection()) != null) {
            conn.close();
        }
    }

    public void shutdown() throws IOException {
        OperatedClientConnection conn;
        AbstractPoolEntry entry2 = this.getPoolEntry();
        if (entry2 != null) {
            entry2.shutdownEntry();
        }
        if ((conn = this.getWrappedConnection()) != null) {
            conn.shutdown();
        }
    }

    public Object getState() {
        AbstractPoolEntry entry2 = this.getPoolEntry();
        this.assertValid(entry2);
        return entry2.getState();
    }

    public void setState(Object state) {
        AbstractPoolEntry entry2 = this.getPoolEntry();
        this.assertValid(entry2);
        entry2.setState(state);
    }
}

