/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.AbstractMatcher;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.LeadingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.NameMatcher;
import org.eclipse.jgit.ignore.internal.Strings;
import org.eclipse.jgit.ignore.internal.TrailingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.WildCardMatcher;
import org.eclipse.jgit.ignore.internal.WildMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathMatcher
extends AbstractMatcher {
    private static final WildMatcher WILD = WildMatcher.INSTANCE;
    private final List<IMatcher> matchers;
    private final char slash;
    private boolean beginning;

    PathMatcher(String pattern2, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        super(pattern2, dirOnly);
        this.slash = Strings.getPathSeparator(pathSeparator);
        this.beginning = pattern2.indexOf(this.slash) == 0;
        this.matchers = this.isSimplePathWithSegments(pattern2) ? null : PathMatcher.createMatchers(Strings.split(pattern2, this.slash), pathSeparator, dirOnly);
    }

    private boolean isSimplePathWithSegments(String path2) {
        return !Strings.isWildCard(path2) && Strings.count(path2, this.slash, true) > 0;
    }

    private static List<IMatcher> createMatchers(List<String> segments2, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        ArrayList<IMatcher> matchers = new ArrayList<IMatcher>(segments2.size());
        for (int i = 0; i < segments2.size(); ++i) {
            String segment = segments2.get(i);
            IMatcher matcher2 = PathMatcher.createNameMatcher0(segment, pathSeparator, dirOnly);
            if (matcher2 == WILD && i > 0 && matchers.get(matchers.size() - 1) == WILD) continue;
            matchers.add(matcher2);
        }
        return matchers;
    }

    public static IMatcher createPathMatcher(String pattern2, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        char slash;
        int slashIdx = (pattern2 = pattern2.trim()).indexOf(slash = Strings.getPathSeparator(pathSeparator), 1);
        if (slashIdx > 0 && slashIdx < pattern2.length() - 1) {
            return new PathMatcher(pattern2, pathSeparator, dirOnly);
        }
        return PathMatcher.createNameMatcher0(pattern2, pathSeparator, dirOnly);
    }

    private static IMatcher createNameMatcher0(String segment, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        if ("**".equals(segment) || "/**".equals(segment)) {
            return WILD;
        }
        Strings.PatternState state = Strings.checkWildCards(segment);
        switch (state) {
            case LEADING_ASTERISK_ONLY: {
                return new LeadingAsteriskMatcher(segment, pathSeparator, dirOnly);
            }
            case TRAILING_ASTERISK_ONLY: {
                return new TrailingAsteriskMatcher(segment, pathSeparator, dirOnly);
            }
            case COMPLEX: {
                return new WildCardMatcher(segment, pathSeparator, dirOnly);
            }
        }
        return new NameMatcher(segment, pathSeparator, dirOnly);
    }

    @Override
    public boolean matches(String path2, boolean assumeDirectory) {
        if (this.matchers == null) {
            return this.simpleMatch(path2, assumeDirectory);
        }
        return this.iterate(path2, 0, path2.length(), assumeDirectory);
    }

    private boolean simpleMatch(String path2, boolean assumeDirectory) {
        boolean hasSlash;
        boolean bl = hasSlash = path2.indexOf(this.slash) == 0;
        if (this.beginning && !hasSlash) {
            path2 = this.slash + path2;
        }
        if (!this.beginning && hasSlash) {
            path2 = path2.substring(1);
        }
        if (path2.equals(this.pattern)) {
            return !this.dirOnly || assumeDirectory;
        }
        return path2.startsWith(this.pattern + '/');
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
        throw new UnsupportedOperationException("Path matcher works only on entire paths");
    }

    boolean iterate(String path2, int startIncl, int endExcl, boolean assumeDirectory) {
        int matcher2 = 0;
        int right = startIncl;
        boolean match = false;
        int lastWildmatch = -1;
        while (true) {
            int left = ++right;
            if ((right = path2.indexOf(this.slash, right)) == -1) {
                if (left < endExcl) {
                    match = this.matches(matcher2, path2, left, endExcl, assumeDirectory);
                }
                if (match) {
                    if (matcher2 == this.matchers.size() - 2 && this.matchers.get(matcher2 + 1) == WILD) {
                        return true;
                    }
                    if (matcher2 < this.matchers.size() - 1 && this.matchers.get(matcher2) == WILD) {
                        match = this.matches(++matcher2, path2, left, endExcl, assumeDirectory);
                    } else if (this.dirOnly && !assumeDirectory) {
                        return false;
                    }
                }
                return match && matcher2 + 1 == this.matchers.size();
            }
            if (right - left <= 0) continue;
            match = this.matches(matcher2, path2, left, right, assumeDirectory);
            if (match) {
                if (this.matchers.get(matcher2) == WILD) {
                    lastWildmatch = matcher2;
                    right = left - 1;
                }
                if (++matcher2 == this.matchers.size()) {
                    return true;
                }
            } else if (lastWildmatch != -1) {
                matcher2 = lastWildmatch + 1;
            } else {
                return false;
            }
            ++right;
        }
    }

    boolean matches(int matcherIdx, String path2, int startIncl, int endExcl, boolean assumeDirectory) {
        IMatcher matcher2 = this.matchers.get(matcherIdx);
        return matcher2.matches(path2, startIncl, endExcl, assumeDirectory);
    }
}

